/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jpa.support.parametersource;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.jpa.support.JpaParameter;
import org.springframework.integration.jpa.support.parametersource.ExpressionEvaluatingParameterSourceUtils;
import org.springframework.integration.jpa.support.parametersource.PositionSupportingParameterSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExpressionEvaluatingParameterSource
implements PositionSupportingParameterSource {
    private static final Log logger = LogFactory.getLog(ExpressionEvaluatingParameterSource.class);
    private static final Object ERROR = new Object();
    private final Object input;
    private volatile Map<String, Object> values = new HashMap<String, Object>();
    private final Map<String, String> parameterExpressions;
    private final List<JpaParameter> parameters;
    private final ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator expressionEvaluator;

    ExpressionEvaluatingParameterSource(Object input, List<JpaParameter> parameters, ExpressionEvaluatingParameterSourceUtils.ParameterExpressionEvaluator expressionEvaluator) {
        this.input = input;
        this.expressionEvaluator = expressionEvaluator;
        this.parameters = parameters;
        this.parameterExpressions = ExpressionEvaluatingParameterSourceUtils.convertExpressions(parameters);
        this.values.putAll(ExpressionEvaluatingParameterSourceUtils.convertStaticParameters(parameters));
    }

    @Override
    public Object getValueByPosition(int position) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0, (String)"The position must be be non-negative.");
        if (position <= this.parameters.size()) {
            JpaParameter parameter = this.parameters.get(position);
            if (parameter.getValue() != null) {
                return parameter.getValue();
            }
            if (parameter.getExpression() != null) {
                String expression = parameter.getExpression();
                if (this.input instanceof Collection) {
                    expression = "#root.![" + expression + "]";
                }
                Object value = this.expressionEvaluator.evaluateExpression(expression, this.input);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resolved expression " + expression + " to " + value));
                }
                return value;
            }
        }
        return null;
    }

    @Override
    public Object getValue(String paramName) {
        if (this.values.containsKey(paramName)) {
            return this.values.get(paramName);
        }
        String expression = paramName;
        if (this.parameterExpressions.containsKey(expression)) {
            expression = this.parameterExpressions.get(expression);
        }
        if (this.input instanceof Collection) {
            expression = "#root.![" + expression + "]";
        }
        Object value = this.expressionEvaluator.evaluateExpression(expression, this.input);
        this.values.put(paramName, value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved expression " + expression + " to " + value));
        }
        return value;
    }

    @Override
    public boolean hasValue(String paramName) {
        try {
            Object value = this.getValue(paramName);
            if (value == ERROR) {
                return false;
            }
        }
        catch (ExpressionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Could not evaluate expression", (Throwable)e);
            }
            this.values.put(paramName, ERROR);
            return false;
        }
        return true;
    }
}

