/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import org.springframework.util.Assert;

public class Partition {
    private String topic;
    private int id;

    public Partition(String topic, int id) {
        Assert.hasText((String)topic, (String)"Topic name cannot be empty");
        Assert.isTrue((id >= 0 ? 1 : 0) != 0, (String)"Partition id must be greater than or equal to 0");
        this.topic = topic;
        this.id = id;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Partition partition = (Partition)o;
        if (this.id != partition.id) {
            return false;
        }
        return this.topic.equals(partition.topic);
    }

    public String toString() {
        return "Partition[topic='" + this.topic + '\'' + ", id=" + this.id + ']';
    }
}

