/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.impl.list.mutable.FastList;
import java.util.List;
import kafka.cluster.Broker;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.integration.kafka.core.AbstractConfiguration;
import org.springframework.integration.kafka.core.BrokerAddress;
import org.springframework.integration.kafka.support.ZookeeperConnect;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;

public class ZookeeperConfiguration
extends AbstractConfiguration {
    private static final Log log = LogFactory.getLog(ZookeeperConfiguration.class);
    public static final BrokerToBrokerAddressFunction brokerToBrokerAddressFunction = new BrokerToBrokerAddressFunction();
    private String zookeeperServers;
    private int sessionTimeout;
    private int connectionTimeout;

    public ZookeeperConfiguration(String zookeeperConnectionString) {
        this(new ZookeeperConnect(zookeeperConnectionString));
    }

    public ZookeeperConfiguration(ZookeeperConnect zookeeperConnect) {
        this.zookeeperServers = zookeeperConnect.getZkConnect();
        try {
            this.sessionTimeout = Integer.parseInt(zookeeperConnect.getZkSessionTimeout());
        }
        catch (NumberFormatException e) {
            throw new BeanInitializationException("Cannot parse session timeout:", (Throwable)e);
        }
        try {
            this.connectionTimeout = Integer.parseInt(zookeeperConnect.getZkConnectionTimeout());
        }
        catch (NumberFormatException e) {
            throw new BeanInitializationException("Cannot parse connection timeout:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<BrokerAddress> doGetBrokerAddresses() {
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(this.zookeeperServers, this.sessionTimeout, this.connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
            Seq allBrokersInCluster = ZkUtils$.MODULE$.getAllBrokersInCluster(zkClient);
            FastList brokers = FastList.newList((java.lang.Iterable)JavaConversions.asJavaCollection((Iterable)allBrokersInCluster));
            FastList fastList = brokers.collect((Function)brokerToBrokerAddressFunction);
            return fastList;
        }
        finally {
            if (zkClient != null) {
                try {
                    zkClient.close();
                }
                catch (Exception e) {
                    log.error((Object)"Cannot close Zookeeper client: ", (Throwable)e);
                }
            }
        }
    }

    private static class BrokerToBrokerAddressFunction
    implements Function<Broker, BrokerAddress> {
        private BrokerToBrokerAddressFunction() {
        }

        public BrokerAddress valueOf(Broker broker) {
            return new BrokerAddress(broker.host(), broker.port());
        }
    }
}

