/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.listener;

import kafka.serializer.Decoder;
import org.springframework.integration.kafka.core.KafkaMessage;
import org.springframework.integration.kafka.core.KafkaMessageMetadata;
import org.springframework.integration.kafka.listener.MessageListener;
import org.springframework.integration.kafka.util.MessageUtils;

public abstract class AbstractDecodingMessageListener<K, P>
implements MessageListener {
    private Decoder<K> keyDecoder;
    private Decoder<P> payloadDecoder;

    public AbstractDecodingMessageListener(Decoder<K> keyDecoder, Decoder<P> payloadDecoder) {
        this.keyDecoder = keyDecoder;
        this.payloadDecoder = payloadDecoder;
    }

    @Override
    public final void onMessage(KafkaMessage message) {
        this.doOnMessage(MessageUtils.decodeKey(message, this.keyDecoder), MessageUtils.decodePayload(message, this.payloadDecoder), message.getMetadata());
    }

    public abstract void doOnMessage(K var1, P var2, KafkaMessageMetadata var3);
}

