/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.kafka.support.ProducerMetadata;

public class ProducerFactoryBean<K, V>
implements FactoryBean<Producer<K, V>> {
    private static final Log LOGGER = LogFactory.getLog(ProducerFactoryBean.class);
    private final String brokerList;
    private final ProducerMetadata<K, V> producerMetadata;
    private Properties producerProperties = new Properties();

    public ProducerFactoryBean(ProducerMetadata<K, V> producerMetadata, String brokerList, Properties producerProperties) {
        this.producerMetadata = producerMetadata;
        this.brokerList = brokerList;
        if (producerProperties != null) {
            this.producerProperties = producerProperties;
        }
    }

    public ProducerFactoryBean(ProducerMetadata<K, V> producerMetadata, String brokerList) {
        this(producerMetadata, brokerList, null);
    }

    public Producer<K, V> getObject() throws Exception {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.producerProperties);
        props.put("bootstrap.servers", this.brokerList);
        props.put("compression.type", this.producerMetadata.getCompressionType().name());
        props.put("batch.size", (Object)this.producerMetadata.getBatchBytes());
        LOGGER.info((Object)("Using producer properties => " + props));
        return new KafkaProducer(props, this.producerMetadata.getKeySerializer(), this.producerMetadata.getValueSerializer());
    }

    public Class<?> getObjectType() {
        return Producer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

