/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.serializer.avro;

import java.io.IOException;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.kafka.serializer.avro.AvroSerializer;

public abstract class AvroDatumSupport<T> {
    private static final Log LOG = LogFactory.getLog(AvroDatumSupport.class);
    private final AvroSerializer<T> avroSerializer = new AvroSerializer();

    protected AvroDatumSupport() {
    }

    public byte[] toBytes(T source, DatumWriter<T> writer) {
        try {
            return this.avroSerializer.serialize(source, writer);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to encode source: " + e));
            return null;
        }
    }

    public T fromBytes(byte[] bytes, DatumReader<T> reader) {
        try {
            return this.avroSerializer.deserialize(bytes, reader);
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to decode byte array: " + e));
            return null;
        }
    }
}

