/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.kafka.core.BrokerAddress;
import org.springframework.integration.kafka.core.Configuration;
import org.springframework.integration.kafka.core.Partition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractConfiguration
implements InitializingBean,
Configuration {
    private List<Partition> defaultPartitions;
    private String defaultTopic;
    private String clientId = "groupid";
    private int minBytes = 1;
    private int maxWait = 100;
    private int bufferSize = 65536;
    private int socketTimeout = 30000;
    private int backoff = 1000;
    private int fetchMetadataTimeout = 10000;

    public void setMinBytes(int minBytes) {
        this.minBytes = minBytes;
    }

    @Override
    public int getMinBytes() {
        return this.minBytes;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public int getMaxWait() {
        return this.maxWait;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public int getBackOff() {
        return this.backoff;
    }

    public void setBackoff(int backoff) {
        this.backoff = backoff;
    }

    public void setFetchMetadataTimeout(int fetchMetadataTimeout) {
        this.fetchMetadataTimeout = fetchMetadataTimeout;
    }

    @Override
    public int getFetchMetadataTimeout() {
        return this.fetchMetadataTimeout;
    }

    @Override
    public final List<BrokerAddress> getBrokerAddresses() {
        return this.doGetBrokerAddresses();
    }

    @Override
    public List<Partition> getDefaultPartitions() {
        return this.defaultPartitions;
    }

    public void setDefaultPartitions(List<Partition> defaultPartitions) {
        this.defaultPartitions = defaultPartitions;
    }

    @Override
    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((CollectionUtils.isEmpty(this.defaultPartitions) || StringUtils.isEmpty((Object)this.defaultTopic) ? 1 : 0) != 0, (String)"A list of default partitions or a default topic may be specified, but not both");
    }

    protected abstract List<BrokerAddress> doGetBrokerAddresses();
}

