/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.impl.list.mutable.FastList;
import org.springframework.integration.kafka.core.BrokerAddress;
import org.springframework.integration.kafka.core.ConnectionFactory;
import org.springframework.integration.kafka.core.FetchRequest;
import org.springframework.integration.kafka.core.KafkaMessageBatch;
import org.springframework.integration.kafka.core.KafkaOperations;
import org.springframework.integration.kafka.core.Result;

public class KafkaTemplate
implements KafkaOperations {
    private final ConnectionFactory connectionFactory;
    private FetchRequestToLeaderBrokerAddress fetchRequestToLeaderBrokerAddress = new FetchRequestToLeaderBrokerAddress();

    public KafkaTemplate(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public Result<KafkaMessageBatch> receive(Iterable<FetchRequest> messageFetchRequests) {
        FastList requestList = FastList.newList(messageFetchRequests);
        FastList distinctBrokerAddresses = requestList.collect((Function)this.fetchRequestToLeaderBrokerAddress).distinct();
        if (distinctBrokerAddresses.size() != 1) {
            throw new IllegalArgumentException("All messages must be fetched from the same broker");
        }
        return this.connectionFactory.connect((BrokerAddress)distinctBrokerAddresses.getFirst()).fetch((FetchRequest[])requestList.toTypedArray(FetchRequest.class));
    }

    private class FetchRequestToLeaderBrokerAddress
    implements Function<FetchRequest, BrokerAddress> {
        private FetchRequestToLeaderBrokerAddress() {
        }

        public BrokerAddress valueOf(FetchRequest fetchRequest) {
            return KafkaTemplate.this.connectionFactory.getLeader(fetchRequest.getPartition());
        }
    }
}

