/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.integration.kafka.core.Partition;
import org.springframework.integration.kafka.core.Result;

class ResultBuilder<T> {
    private Map<Partition, T> result = new HashMap<Partition, T>();
    private Map<Partition, Short> errors = new HashMap<Partition, Short>();

    public KafkaPartitionResultHolder add(Partition Partition2) {
        return new KafkaPartitionResultHolder(Partition2);
    }

    public Result<T> build() {
        return new Result<T>(this.result, this.errors);
    }

    class KafkaPartitionResultHolder {
        private Partition partition;

        public KafkaPartitionResultHolder(Partition Partition2) {
            this.partition = Partition2;
        }

        public ResultBuilder<T> withResult(T result) {
            if (ResultBuilder.this.errors.containsKey(this.partition)) {
                throw new IllegalArgumentException("A KafkaResult cannot contain both an error and a result for the same topic and partition");
            }
            ResultBuilder.this.result.put(this.partition, result);
            return ResultBuilder.this;
        }

        public ResultBuilder<T> withError(short error) {
            if (ResultBuilder.this.result.containsKey(this.partition)) {
                throw new IllegalArgumentException("A FetchResult cannot contain both an error and a MessageSet for the same topic and partition");
            }
            ResultBuilder.this.errors.put(this.partition, error);
            return ResultBuilder.this;
        }
    }
}

