/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.outbound;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.kafka.support.KafkaProducerContext;
import org.springframework.messaging.Message;

public class KafkaProducerMessageHandler
extends AbstractMessageHandler {
    private final KafkaProducerContext kafkaProducerContext;
    private EvaluationContext evaluationContext;
    private boolean enableHeaderRouting = true;
    private volatile Expression topicExpression;
    private volatile Expression messageKeyExpression;
    private volatile Expression partitionIdExpression;

    public KafkaProducerMessageHandler(KafkaProducerContext kafkaProducerContext) {
        this.kafkaProducerContext = kafkaProducerContext;
    }

    public void setEnableHeaderRouting(boolean enableHeaderRouting) {
        this.enableHeaderRouting = enableHeaderRouting;
    }

    public void setTopicExpression(Expression topicExpression) {
        this.topicExpression = topicExpression;
    }

    public void setMessageKeyExpression(Expression messageKeyExpression) {
        this.messageKeyExpression = messageKeyExpression;
    }

    @Deprecated
    public void setPartitionExpression(Expression partitionExpression) {
        this.setPartitionIdExpression(partitionExpression);
    }

    public void setPartitionIdExpression(Expression partitionIdExpression) {
        this.partitionIdExpression = partitionIdExpression;
    }

    public KafkaProducerContext getKafkaProducerContext() {
        return this.kafkaProducerContext;
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String topic;
        String string = this.topicExpression != null ? (String)this.topicExpression.getValue(this.evaluationContext, message, String.class) : (topic = this.enableHeaderRouting ? (String)message.getHeaders().get((Object)"kafka_topic", String.class) : null);
        Integer partitionId = this.partitionIdExpression != null ? (Integer)this.partitionIdExpression.getValue(this.evaluationContext, message, Integer.class) : (this.enableHeaderRouting ? (Integer)message.getHeaders().get((Object)"kafka_partitionId", Integer.class) : null);
        Object messageKey = this.messageKeyExpression != null ? this.messageKeyExpression.getValue(this.evaluationContext, message) : message.getHeaders().get((Object)"kafka_messageKey");
        this.kafkaProducerContext.send(topic, partitionId, messageKey, message.getPayload());
    }

    public String getComponentType() {
        return "kafka:outbound-channel-adapter";
    }
}

