/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import java.nio.charset.Charset;
import kafka.producer.Partitioner;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.util.Assert;

public class ProducerMetadata<K, V> {
    private final Class<K> keyClassType;
    private final Class<V> valueClassType;
    private Serializer<K> keySerializer;
    private Serializer<V> valueSerializer;
    private final String topic;
    private Partitioner partitioner;
    private CompressionType compressionType = CompressionType.none;
    private int batchBytes = 16384;
    private int sendTimeout = 0;
    private boolean sync = false;
    private Charset charset = Charset.forName("UTF8");

    public ProducerMetadata(String topic, Class<K> keyClassType, Class<V> valueClassType, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        Assert.notNull((Object)topic, (String)"Topic cannot be null");
        Assert.notNull(keyClassType, (String)"Key class type serializer cannot be null");
        Assert.notNull(valueClassType, (String)"Value class type cannot be null");
        Assert.notNull(keySerializer, (String)"Value serializer cannot be null");
        Assert.notNull(valueSerializer, (String)"Value serializer cannot be null");
        this.topic = topic;
        this.keyClassType = keyClassType;
        this.valueClassType = valueClassType;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public String getTopic() {
        return this.topic;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        Assert.notNull((Object)((Object)compressionType), (String)"Compression type cannot be null");
        this.compressionType = compressionType;
    }

    public int getBatchBytes() {
        return this.batchBytes;
    }

    public void setBatchBytes(int batchBytes) {
        Assert.isTrue((batchBytes > 0 ? 1 : 0) != 0, (String)"Buffer size must be greater than zero");
        this.batchBytes = batchBytes;
    }

    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public Class<K> getKeyClassType() {
        return this.keyClassType;
    }

    public Class<V> getValueClassType() {
        return this.valueClassType;
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public String toString() {
        return "ProducerMetadata{keyClassType=" + this.keyClassType + ", valueClassType=" + this.valueClassType + ", keySerializer=" + this.keySerializer + ", valueSerializer=" + this.valueSerializer + ", topic='" + this.topic + '\'' + ", partitioner=" + this.partitioner + ", compressionType=" + (Object)((Object)this.compressionType) + ", batchBytes=" + this.batchBytes + ", sync=" + this.sync + ", sendTimeout=" + this.sendTimeout + ", charset=" + this.charset + '}';
    }

    public static enum CompressionType {
        none,
        gzip,
        snappy;

    }
}

