/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.w3c.dom.Element;

public class KafkaOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinition partitionIdExpressionDef;
        BeanDefinition messageKeyExpressionDef;
        BeanDefinitionBuilder kafkaProducerMessageHandlerBuilder = BeanDefinitionBuilder.genericBeanDefinition(KafkaProducerMessageHandler.class);
        String kafkaTemplateBeanName = element.getAttribute("kafka-template");
        kafkaProducerMessageHandlerBuilder.addConstructorArgReference(kafkaTemplateBeanName);
        BeanDefinition topicExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"topic", (String)"topic-expression", (ParserContext)parserContext, (Element)element, (boolean)false);
        if (topicExpressionDef != null) {
            kafkaProducerMessageHandlerBuilder.addPropertyValue("topicExpression", (Object)topicExpressionDef);
        }
        if ((messageKeyExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"message-key", (String)"message-key-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            kafkaProducerMessageHandlerBuilder.addPropertyValue("messageKeyExpression", (Object)messageKeyExpressionDef);
        }
        if ((partitionIdExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"partition-id", (String)"partition-id-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            kafkaProducerMessageHandlerBuilder.addPropertyValue("partitionIdExpression", (Object)partitionIdExpressionDef);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)kafkaProducerMessageHandlerBuilder, (Element)element, (String)"sync");
        return kafkaProducerMessageHandlerBuilder.getBeanDefinition();
    }
}

