/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.Pop3MailReceiver;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailReceiverFactoryBean
implements FactoryBean,
DisposableBean {
    private volatile String storeUri;
    private volatile MailReceiver receiver;
    private volatile Properties javaMailProperties;
    private volatile int maxFetchSize = 1;

    public void setStoreUri(String storeUri) {
        this.storeUri = storeUri;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public Object getObject() throws Exception {
        if (this.receiver == null) {
            this.receiver = this.createReceiver();
        }
        return this.receiver;
    }

    public Class<?> getObjectType() {
        return this.receiver != null ? this.receiver.getClass() : MailReceiver.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private MailReceiver createReceiver() {
        AbstractMailReceiver receiver;
        Assert.hasText((String)this.storeUri, (String)"the store URI is required");
        boolean isPop3 = this.storeUri.toLowerCase().startsWith("pop3");
        boolean isImap = this.storeUri.toLowerCase().startsWith("imap");
        Assert.isTrue((isPop3 || isImap ? 1 : 0) != 0, (String)"the store URI must begin with 'pop3' or 'imap'");
        AbstractMailReceiver abstractMailReceiver = receiver = isPop3 ? new Pop3MailReceiver(this.storeUri) : new ImapMailReceiver(this.storeUri);
        if (this.javaMailProperties != null) {
            receiver.setJavaMailProperties(this.javaMailProperties);
        }
        receiver.setMaxFetchSize(this.maxFetchSize);
        return receiver;
    }

    public void destroy() throws Exception {
        if (this.receiver != null && this.receiver instanceof DisposableBean) {
            ((DisposableBean)this.receiver).destroy();
        }
    }
}

