/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.config;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.URLName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.Pop3MailReceiver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailReceiverFactoryBean
implements FactoryBean<MailReceiver>,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String storeUri;
    private volatile String protocol;
    private volatile Session session;
    private volatile MailReceiver receiver;
    private volatile Properties javaMailProperties;
    private volatile Authenticator authenticator;
    private volatile Boolean shouldDeleteMessages = null;
    private volatile Boolean shouldMarkMessagesAsRead = null;
    private volatile int maxFetchSize = 1;

    public void setStoreUri(String storeUri) {
        this.storeUri = storeUri;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setShouldDeleteMessages(Boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public MailReceiver getObject() throws Exception {
        if (this.receiver == null) {
            this.receiver = this.createReceiver();
        }
        return this.receiver;
    }

    public Class<?> getObjectType() {
        return this.receiver != null ? this.receiver.getClass() : MailReceiver.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void verifyProtocol() {
        if (StringUtils.hasText((String)this.storeUri)) {
            URLName urlName = new URLName(this.storeUri);
            if (this.protocol == null) {
                this.protocol = urlName.getProtocol();
            } else {
                Assert.isTrue((boolean)this.protocol.equals(urlName.getProtocol()), (String)"The provided 'protocol' does not match that in the 'storeUri'.");
            }
        } else {
            Assert.hasText((String)this.protocol, (String)"Either the 'storeUri' or 'protocol' is required.");
        }
        Assert.hasText((String)this.protocol, (String)"Unable to resolve protocol.");
    }

    private MailReceiver createReceiver() {
        AbstractMailReceiver receiver;
        this.verifyProtocol();
        boolean isPop3 = this.protocol.toLowerCase().startsWith("pop3");
        boolean isImap = this.protocol.toLowerCase().startsWith("imap");
        Assert.isTrue((isPop3 || isImap ? 1 : 0) != 0, (String)"the store URI must begin with 'pop3' or 'imap'");
        AbstractMailReceiver abstractMailReceiver = receiver = isPop3 ? new Pop3MailReceiver(this.storeUri) : new ImapMailReceiver(this.storeUri);
        if (this.session != null) {
            Assert.isNull((Object)this.javaMailProperties, (String)"JavaMail Properties are not allowed when a Session has been provided.");
            Assert.isNull((Object)this.authenticator, (String)"A JavaMail Authenticator is not allowed when a Session has been provied.");
            receiver.setSession(this.session);
        }
        if (this.javaMailProperties != null) {
            receiver.setJavaMailProperties(this.javaMailProperties);
        }
        if (this.authenticator != null) {
            receiver.setJavaMailAuthenticator(this.authenticator);
        }
        if (this.shouldDeleteMessages != null) {
            receiver.setShouldDeleteMessages(this.shouldDeleteMessages);
        }
        receiver.setMaxFetchSize(this.maxFetchSize);
        if (this.isShouldMarkMessagesAsRead().booleanValue()) {
            if (isPop3) {
                this.logger.warn((Object)"Setting 'should-mark-messages-as-read' to 'true' while using POP3 has no effect");
            } else if (isImap) {
                ((ImapMailReceiver)receiver).setShouldMarkMessagesAsRead(this.shouldMarkMessagesAsRead);
            }
        }
        receiver.afterPropertiesSet();
        return receiver;
    }

    public void destroy() throws Exception {
        if (this.receiver != null && this.receiver instanceof DisposableBean) {
            ((DisposableBean)this.receiver).destroy();
        }
    }

    public Boolean isShouldMarkMessagesAsRead() {
        return this.shouldMarkMessagesAsRead != null && this.shouldMarkMessagesAsRead != false;
    }

    public void setShouldMarkMessagesAsRead(Boolean shouldMarkMessagesAsRead) {
        this.shouldMarkMessagesAsRead = shouldMarkMessagesAsRead;
    }
}

