/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.mail.MailReceiver;
import org.springframework.integration.mail.MailTransportUtils;
import org.springframework.util.Assert;

public abstract class AbstractMailReceiver
extends IntegrationObjectSupport
implements MailReceiver,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final URLName url;
    private volatile String protocol;
    private volatile int maxFetchSize = -1;
    private volatile Session session;
    private volatile Store store;
    private volatile Folder folder;
    private volatile boolean shouldDeleteMessages;
    protected volatile int folderOpenMode = 1;
    private volatile Properties javaMailProperties = new Properties();
    protected volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private Authenticator javaMailAuthenticator;

    public AbstractMailReceiver() {
        this.url = null;
    }

    public AbstractMailReceiver(URLName urlName) {
        Assert.notNull((Object)urlName, (String)"urlName must not be null");
        this.url = urlName;
    }

    public AbstractMailReceiver(String url) {
        this.url = url != null ? new URLName(url) : null;
    }

    public void setProtocol(String protocol) {
        if (this.url != null) {
            Assert.isTrue((boolean)this.url.getProtocol().equals(protocol), (String)"The 'protocol' does not match that provided by the Store URI.");
        }
        this.protocol = protocol;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public void setJavaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.javaMailAuthenticator = javaMailAuthenticator;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public void setShouldDeleteMessages(boolean shouldDeleteMessages) {
        this.shouldDeleteMessages = shouldDeleteMessages;
    }

    protected boolean shouldDeleteMessages() {
        return this.shouldDeleteMessages;
    }

    protected Folder getFolder() {
        return this.folder;
    }

    protected abstract Message[] searchForNewMessages() throws javax.mail.MessagingException;

    private void openSession() throws javax.mail.MessagingException {
        if (this.session == null) {
            this.session = this.javaMailAuthenticator != null ? Session.getInstance((Properties)this.javaMailProperties, (Authenticator)this.javaMailAuthenticator) : Session.getInstance((Properties)this.javaMailProperties);
        }
        if (this.store == null) {
            this.store = this.url != null ? this.session.getStore(this.url) : (this.protocol != null ? this.session.getStore(this.protocol) : this.session.getStore());
        }
        if (!this.store.isConnected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("connecting to store [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
            }
            this.store.connect();
        }
    }

    protected void openFolder() throws javax.mail.MessagingException {
        this.openSession();
        if (this.folder == null) {
            this.folder = this.store.getFolder(this.url);
        }
        if (this.folder == null || !this.folder.exists()) {
            throw new IllegalStateException("no such folder [" + this.url.getFile() + "]");
        }
        if (this.folder.isOpen()) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("opening folder [" + MailTransportUtils.toPasswordProtectedString(this.url) + "]"));
        }
        this.folder.open(this.folderOpenMode);
    }

    public synchronized Message[] receive() {
        try {
            this.openFolder();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("attempting to receive mail from folder [" + this.getFolder().getFullName() + "]"));
            }
            Message[] messages = this.searchForNewMessages();
            if (this.maxFetchSize > 0 && messages.length > this.maxFetchSize) {
                Message[] reducedMessages = new Message[this.maxFetchSize];
                System.arraycopy(messages, 0, reducedMessages, 0, this.maxFetchSize);
                messages = reducedMessages;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("found " + messages.length + " new messages"));
            }
            if (messages.length > 0) {
                this.fetchMessages(messages);
            }
            Message[] copiedMessages = new Message[messages.length];
            for (int i = 0; i < messages.length; ++i) {
                this.setAdditionalFlags(messages[i]);
                copiedMessages[i] = new MimeMessage((MimeMessage)messages[i]);
            }
            if (this.shouldDeleteMessages()) {
                this.deleteMessages(messages);
            }
            Message[] messageArray = copiedMessages;
            return messageArray;
        }
        catch (Exception e) {
            throw new MessagingException("failure occurred while receiving from folder", (Throwable)e);
        }
        finally {
            MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
        }
    }

    protected void fetchMessages(Message[] messages) throws javax.mail.MessagingException {
        FetchProfile contentsProfile = new FetchProfile();
        contentsProfile.add(FetchProfile.Item.ENVELOPE);
        contentsProfile.add(FetchProfile.Item.CONTENT_INFO);
        contentsProfile.add(FetchProfile.Item.FLAGS);
        this.folder.fetch(messages, contentsProfile);
    }

    protected void deleteMessages(Message[] messages) throws javax.mail.MessagingException {
        for (int i = 0; i < messages.length; ++i) {
            messages[i].setFlag(Flags.Flag.DELETED, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            MailTransportUtils.closeFolder(this.folder, this.shouldDeleteMessages);
            MailTransportUtils.closeService((Service)this.store);
            this.folder = null;
            this.store = null;
            this.initialized = false;
        }
    }

    public String toString() {
        return this.url.toString();
    }

    protected void setAdditionalFlags(Message message) throws javax.mail.MessagingException {
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.shouldDeleteMessages) {
            this.folderOpenMode = 2;
        }
    }

    Store getStore() {
        return this.store;
    }
}

