/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.security.ProviderException;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.ResubmittingTask;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapter
extends MessageProducerSupport {
    private final IdleTask idleTask = new IdleTask();
    private volatile boolean shouldReconnectAutomatically = true;
    private volatile Executor taskExecutor;
    private final ImapMailReceiver mailReceiver;
    private volatile int reconnectDelay = 10000;
    private volatile ScheduledFuture<?> scheduledFuture;

    public ImapIdleChannelAdapter(ImapMailReceiver mailReceiver) {
        Assert.notNull((Object)mailReceiver, (String)"mailReceiver must not be null");
        this.mailReceiver = mailReceiver;
    }

    public void setShouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        this.shouldReconnectAutomatically = shouldReconnectAutomatically;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public String getComponentType() {
        return "mail:imap-idle-channel-adapter";
    }

    protected void handleMailMessagingException(MessagingException e) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"error occurred in idle task", (Throwable)e);
        }
    }

    protected void doStart() {
        TaskScheduler scheduler = this.getTaskScheduler();
        Assert.notNull((Object)scheduler, (String)"'taskScheduler' must not be null");
        ResubmittingTask task = new ResubmittingTask(this.idleTask, scheduler, this.reconnectDelay);
        task.setTaskExecutor(this.taskExecutor);
        this.scheduledFuture = scheduler.schedule((Runnable)new ResubmittingTask(this.idleTask, scheduler, this.reconnectDelay), new Date());
    }

    protected void doStop() {
        this.scheduledFuture.cancel(true);
    }

    private class IdleTask
    implements Runnable {
        private IdleTask() {
        }

        public void run() {
            try {
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)"waiting for mail");
                }
                ImapIdleChannelAdapter.this.mailReceiver.waitForNewMessages();
                Message[] mailMessages = ImapIdleChannelAdapter.this.mailReceiver.receive();
                if (ImapIdleChannelAdapter.this.logger.isDebugEnabled()) {
                    ImapIdleChannelAdapter.this.logger.debug((Object)("received " + mailMessages.length + " mail messages"));
                }
                for (Message mailMessage : mailMessages) {
                    MimeMessage copied = new MimeMessage((MimeMessage)mailMessage);
                    ImapIdleChannelAdapter.this.sendMessage(MessageBuilder.withPayload((Object)copied).build());
                }
            }
            catch (MessagingException e) {
                ImapIdleChannelAdapter.this.handleMailMessagingException(e);
                if (ImapIdleChannelAdapter.this.shouldReconnectAutomatically) {
                    throw new ProviderException("Failure in 'idle' task. Will resubmit", e);
                }
                throw new RejectedExecutionException("Failure in 'idle' task. Will NOT resubmit", e);
            }
        }
    }
}

