/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import com.sun.mail.imap.IMAPFolder;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.event.MessageCountAdapter;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.SearchTerm;
import org.springframework.integration.mail.AbstractMailReceiver;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class ImapMailReceiver
extends AbstractMailReceiver {
    private volatile boolean shouldMarkMessagesAsRead = true;
    private final MessageCountListener messageCountListener = new SimpleMessageCountListener();
    private volatile long connectionPingInterval = 10000L;

    public ImapMailReceiver() {
        this.setProtocol("imap");
    }

    public ImapMailReceiver(String url) {
        super(url);
        if (url != null) {
            Assert.isTrue((boolean)url.toLowerCase().startsWith("imap"), (String)"URL must start with 'imap' for the IMAP Mail receiver.");
        } else {
            this.setProtocol("imap");
        }
    }

    public Boolean isShouldMarkMessagesAsRead() {
        return this.shouldMarkMessagesAsRead;
    }

    public void setShouldMarkMessagesAsRead(Boolean shouldMarkMessagesAsRead) {
        this.shouldMarkMessagesAsRead = shouldMarkMessagesAsRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNewMessages() throws MessagingException {
        this.openFolder();
        Assert.state((boolean)(this.getFolder() instanceof IMAPFolder), (String)("folder is not an instance of [" + IMAPFolder.class.getName() + "]"));
        IMAPFolder imapFolder = (IMAPFolder)this.getFolder();
        if (imapFolder.hasNewMessages()) {
            return;
        }
        imapFolder.addMessageCountListener(this.messageCountListener);
        try {
            imapFolder.idle();
        }
        finally {
            imapFolder.removeMessageCountListener(this.messageCountListener);
        }
    }

    protected Message[] searchForNewMessages() throws MessagingException {
        Flags supportedFlags = this.getFolder().getPermanentFlags();
        SearchTerm searchTerm = this.compileSearchTerms(supportedFlags);
        Folder folder = this.getFolder();
        if (folder.isOpen()) {
            return searchTerm != null ? folder.search(searchTerm) : folder.getMessages();
        }
        throw new MessagingException("Folder is closed");
    }

    private SearchTerm compileSearchTerms(Flags supportedFlags) {
        Object searchTerm = null;
        if (supportedFlags != null) {
            if (supportedFlags.contains(Flags.Flag.RECENT)) {
                searchTerm = new FlagTerm(new Flags(Flags.Flag.RECENT), true);
            }
            if (supportedFlags.contains(Flags.Flag.ANSWERED)) {
                FlagTerm answeredTerm = new FlagTerm(new Flags(Flags.Flag.ANSWERED), false);
                searchTerm = searchTerm == null ? answeredTerm : new AndTerm((SearchTerm)searchTerm, (SearchTerm)answeredTerm);
            }
            if (supportedFlags.contains(Flags.Flag.DELETED)) {
                FlagTerm deletedTerm = new FlagTerm(new Flags(Flags.Flag.DELETED), false);
                searchTerm = searchTerm == null ? deletedTerm : new AndTerm((SearchTerm)searchTerm, (SearchTerm)deletedTerm);
            }
        }
        NotTerm notDeleted = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DELETED), true));
        NotTerm notSeen = new NotTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), true));
        if (searchTerm == null) {
            searchTerm = notDeleted;
        }
        if (this.isShouldMarkMessagesAsRead().booleanValue()) {
            searchTerm = new AndTerm((SearchTerm)searchTerm, (SearchTerm)notSeen);
        }
        return searchTerm;
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.shouldMarkMessagesAsRead) {
            this.folderOpenMode = 2;
        }
        this.initialized = true;
        TaskScheduler scheduler = this.getTaskScheduler();
        if (scheduler != null) {
            scheduler.scheduleAtFixedRate(new Runnable(){

                public void run() {
                    try {
                        Store store = ImapMailReceiver.this.getStore();
                        if (ImapMailReceiver.this.initialized && store != null) {
                            store.isConnected();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, this.connectionPingInterval);
        }
    }

    protected void setAdditionalFlags(Message message) throws MessagingException {
        super.setAdditionalFlags(message);
        if (this.shouldMarkMessagesAsRead) {
            message.setFlag(Flags.Flag.SEEN, true);
        }
    }

    private static class SimpleMessageCountListener
    extends MessageCountAdapter {
        private SimpleMessageCountListener() {
        }

        public void messagesAdded(MessageCountEvent event) {
            Message[] messages;
            for (Message message : messages = event.getMessages()) {
                try {
                    message.getLineCount();
                }
                catch (MessagingException e) {
                    // empty catch block
                }
            }
        }
    }
}

