/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail;

import java.security.ProviderException;
import java.util.Date;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.TaskScheduler;

class ResubmittingTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(ResubmittingTask.class);
    private final Runnable targetTask;
    private final TaskScheduler scheduler;
    private final long delay;
    private Executor taskExecutor = new SimpleAsyncTaskExecutor();

    public ResubmittingTask(Runnable targetTask, TaskScheduler scheduler, long delay) {
        this.targetTask = targetTask;
        this.scheduler = scheduler;
        this.delay = delay;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor != null ? taskExecutor : new SimpleAsyncTaskExecutor();
    }

    public void run() {
        this.taskExecutor.execute(new Runnable(){

            public void run() {
                ResubmittingTask.this.invokeTask();
            }
        });
    }

    private void invokeTask() {
        try {
            this.targetTask.run();
            logger.debug((Object)"Task completed successfully. Re-scheduling it again right away");
            this.scheduler.schedule((Runnable)this, new Date());
        }
        catch (ProviderException e) {
            logger.warn((Object)("Failed to execute IDLE task. Will atempt to resubmit in " + this.delay + " milliseconds"), (Throwable)e);
            this.scheduler.schedule((Runnable)this, new Date(System.currentTimeMillis() + this.delay));
        }
    }
}

