/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mail.support;

import jakarta.mail.Address;
import jakarta.mail.Message;
import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.MessagingException;
import org.springframework.util.StringUtils;

public final class MailUtils {
    private MailUtils() {
    }

    public static Map<String, Object> extractStandardHeaders(Message source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        try {
            headers.put("mail_from", StringUtils.arrayToCommaDelimitedString((Object[])source.getFrom()));
            headers.put("mail_bcc", MailUtils.convertToStringArray(source.getRecipients(Message.RecipientType.BCC)));
            headers.put("mail_cc", MailUtils.convertToStringArray(source.getRecipients(Message.RecipientType.CC)));
            headers.put("mail_to", MailUtils.convertToStringArray(source.getRecipients(Message.RecipientType.TO)));
            headers.put("mail_replyTo", StringUtils.arrayToCommaDelimitedString((Object[])source.getReplyTo()));
            headers.put("mail_subject", source.getSubject());
            return headers;
        }
        catch (Exception ex) {
            throw new MessagingException("conversion of MailMessage headers failed", (Throwable)ex);
        }
    }

    private static String[] convertToStringArray(Address[] addresses) {
        if (addresses != null) {
            String[] addressStrings = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                addressStrings[i] = addresses[i].toString();
            }
            return addressStrings;
        }
        return new String[0];
    }
}

