/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.outbound;

import org.springframework.context.Lifecycle;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.mqtt.support.DefaultPahoMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractMqttMessageHandler
extends AbstractMessageHandler
implements Lifecycle {
    private final String url;
    private final String clientId;
    private volatile String defaultTopic;
    private volatile int defaultQos = 0;
    private volatile boolean defaultRetained = false;
    private volatile MessageConverter converter;
    private boolean running;
    private volatile int clientInstance;

    public AbstractMqttMessageHandler(String url, String clientId) {
        Assert.hasText((String)clientId, (String)"'clientId' cannot be null or empty");
        this.url = url;
        this.clientId = clientId;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public void setDefaultQos(int defaultQos) {
        this.defaultQos = defaultQos;
    }

    public void setDefaultRetained(boolean defaultRetain) {
        this.defaultRetained = defaultRetain;
    }

    public void setConverter(MessageConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' cannot be null");
        this.converter = converter;
    }

    protected MessageConverter getConverter() {
        return this.converter;
    }

    protected String getUrl() {
        return this.url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getClientInstance() {
        return this.clientInstance;
    }

    public String getComponentType() {
        return "mqtt:outbound-channel-adapter";
    }

    protected void incrementClientInstance() {
        ++this.clientInstance;
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.converter == null) {
            this.converter = new DefaultPahoMessageConverter(this.defaultQos, this.defaultRetained);
        }
    }

    public final void start() {
        this.doStart();
        this.running = true;
    }

    protected abstract void doStart();

    public final void stop() {
        this.doStop();
        this.running = false;
    }

    protected abstract void doStop();

    public boolean isRunning() {
        return this.running;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        this.connectIfNeeded();
        String topic = (String)message.getHeaders().get((Object)"mqtt_topic");
        Object mqttMessage = this.converter.fromMessage(message, Object.class);
        if (topic == null && this.defaultTopic == null) {
            throw new MessageHandlingException(message, "No 'mqtt_topic' header and no default topic defined");
        }
        this.publish(topic == null ? this.defaultTopic : topic, mqttMessage, message);
    }

    @Deprecated
    protected void connectIfNeeded() {
    }

    protected abstract void publish(String var1, Object var2, Message<?> var3) throws Exception;
}

