/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.support;

import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.mqtt.support.MqttMessageConverter;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;

public class DefaultPahoMessageConverter
implements MqttMessageConverter,
BeanFactoryAware {
    private final String charset;
    private final Integer defaultQos;
    private final Boolean defaultRetained;
    private volatile boolean payloadAsBytes = false;
    private volatile BeanFactory beanFactory;
    private volatile MessageBuilderFactory messageBuilderFactory = new DefaultMessageBuilderFactory();
    private volatile boolean messageBuilderFactorySet;

    public DefaultPahoMessageConverter() {
        this(0, false);
    }

    public DefaultPahoMessageConverter(int defaultQos, boolean defaultRetain) {
        this(defaultQos, defaultRetain, "UTF-8");
    }

    public DefaultPahoMessageConverter(String charset) {
        this(0, false, charset);
    }

    public DefaultPahoMessageConverter(int defaultQos, boolean defaultRetained, String charset) {
        this.defaultQos = defaultQos;
        this.defaultRetained = defaultRetained;
        this.charset = charset;
    }

    public final void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected MessageBuilderFactory getMessageBuilderFactory() {
        if (!this.messageBuilderFactorySet) {
            if (this.beanFactory != null) {
                this.messageBuilderFactory = IntegrationUtils.getMessageBuilderFactory((BeanFactory)this.beanFactory);
            }
            this.messageBuilderFactorySet = true;
        }
        return this.messageBuilderFactory;
    }

    public void setPayloadAsBytes(boolean payloadAsBytes) {
        this.payloadAsBytes = payloadAsBytes;
    }

    public boolean isPayloadAsBytes() {
        return this.payloadAsBytes;
    }

    public Message<?> toMessage(Object mqttMessage, MessageHeaders headers) {
        if (!(mqttMessage instanceof MqttMessage)) {
            throw new IllegalArgumentException("This converter can only convert an 'MqttMessage'; received: " + mqttMessage.getClass().getName());
        }
        return this.toMessage(null, (MqttMessage)mqttMessage);
    }

    @Override
    public Message<?> toMessage(String topic, MqttMessage mqttMessage) {
        try {
            AbstractIntegrationMessageBuilder messageBuilder = this.getMessageBuilderFactory().withPayload(this.mqttBytesToPayload(mqttMessage)).setHeader("mqtt_qos", (Object)mqttMessage.getQos()).setHeader("mqtt_duplicate", (Object)mqttMessage.isDuplicate()).setHeader("mqtt_retained", (Object)mqttMessage.isRetained());
            if (topic != null) {
                messageBuilder.setHeader("mqtt_topic", (Object)topic);
            }
            return messageBuilder.build();
        }
        catch (Exception e) {
            throw new MessageConversionException("failed to convert object to Message", (Throwable)e);
        }
    }

    public MqttMessage fromMessage(Message<?> message, Class<?> targetClass) {
        byte[] payloadBytes = this.messageToMqttBytes(message);
        MqttMessage mqttMessage = new MqttMessage(payloadBytes);
        Object header = message.getHeaders().get((Object)"mqtt_retained");
        Assert.isTrue((header == null || header instanceof Boolean ? 1 : 0) != 0, (String)"mqtt_retained header must be Boolean");
        mqttMessage.setRetained((header == null ? this.defaultRetained : (Boolean)header).booleanValue());
        header = message.getHeaders().get((Object)"mqtt_qos");
        Assert.isTrue((header == null || header instanceof Integer ? 1 : 0) != 0, (String)"mqtt_qos header must be Integer");
        mqttMessage.setQos((header == null ? this.defaultQos : (Integer)header).intValue());
        return mqttMessage;
    }

    protected Object mqttBytesToPayload(MqttMessage mqttMessage) throws Exception {
        if (this.payloadAsBytes) {
            return mqttMessage.getPayload();
        }
        return new String(mqttMessage.getPayload(), this.charset);
    }

    protected byte[] messageToMqttBytes(Message<?> message) {
        byte[] payloadBytes;
        Object payload = message.getPayload();
        if (!(payload instanceof byte[]) && !(payload instanceof String)) {
            throw new IllegalArgumentException("This default converter can only handle 'byte[]' or 'String' payloads; consider adding a transformer to your flow definition, or subclass this converter for " + payload.getClass().getName() + " payloads");
        }
        if (payload instanceof String) {
            try {
                payloadBytes = ((String)payload).getBytes(this.charset);
            }
            catch (Exception e) {
                throw new MessageConversionException("failed to convert Message to object", (Throwable)e);
            }
        } else {
            payloadBytes = (byte[])payload;
        }
        return payloadBytes;
    }
}

