/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.redis.outbound;

import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.integration.Message;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.support.converter.MessageConverter;
import org.springframework.integration.support.converter.SimpleMessageConverter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisPublishingMessageHandler
extends AbstractMessageHandler {
    private final StringRedisTemplate template;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile String defaultTopic;
    private volatile RedisSerializer<?> serializer = new StringRedisSerializer();

    public RedisPublishingMessageHandler(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"connectionFactory must not be null");
        this.template = new StringRedisTemplate(connectionFactory);
    }

    public void setSerializer(RedisSerializer<?> serializer) {
        Assert.notNull(serializer, (String)"'serializer' must not be null");
        this.serializer = serializer;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"messageConverter must not be null");
        this.messageConverter = messageConverter;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    private String determineTopic(Message<?> message) {
        Assert.hasText((String)this.defaultTopic, (String)"Failed to determine Redis topic from Message, and no defaultTopic has been provided.");
        return this.defaultTopic;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String topic = this.determineTopic(message);
        Object value = this.messageConverter.fromMessage(message);
        this.template.convertAndSend(topic, (Object)value.toString());
    }

    protected void onInit() throws Exception {
        this.template.setValueSerializer(this.serializer);
        this.template.afterPropertiesSet();
    }
}

