/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.rmi;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.context.NamedComponent;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.remoting.rmi.RmiServiceExporter;
import org.springframework.remoting.support.RemoteInvocationExecutor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiInboundGateway
extends MessagingGatewaySupport
implements RequestReplyExchanger,
InitializingBean {
    public static final String SERVICE_NAME_PREFIX = "org.springframework.integration.rmiGateway.";
    private volatile String requestChannelName;
    private volatile String registryHost;
    private volatile int registryPort = 1099;
    private volatile boolean expectReply = true;
    private volatile RemoteInvocationExecutor remoteInvocationExecutor;
    private volatile RmiServiceExporter exporter;
    private final Object initializationMonitor = new Object();

    public void setRequestChannel(MessageChannel requestChannel) {
        Assert.notNull((Object)requestChannel, (String)"requestChannel must not be null");
        Assert.isTrue((requestChannel instanceof NamedComponent && StringUtils.hasText((String)((NamedComponent)requestChannel).getComponentName()) ? 1 : 0) != 0, (String)"RmiGateway's request channel must have a name.");
        this.requestChannelName = ((NamedComponent)requestChannel).getComponentName();
        super.setRequestChannel(requestChannel);
    }

    public void setExpectReply(boolean expectReply) {
        this.expectReply = expectReply;
    }

    public void setRegistryHost(String registryHost) {
        this.registryHost = registryHost;
    }

    public void setRegistryPort(int registryPort) {
        this.registryPort = registryPort;
    }

    public void setRemoteInvocationExecutor(RemoteInvocationExecutor remoteInvocationExecutor) {
        this.remoteInvocationExecutor = remoteInvocationExecutor;
    }

    public String getComponentType() {
        return "rmi:inbound-gateway";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onInit() throws Exception {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.exporter == null) {
                RmiServiceExporter exporter = new RmiServiceExporter();
                if (this.registryHost != null) {
                    exporter.setRegistryHost(this.registryHost);
                }
                exporter.setRegistryPort(this.registryPort);
                if (this.remoteInvocationExecutor != null) {
                    exporter.setRemoteInvocationExecutor(this.remoteInvocationExecutor);
                }
                exporter.setService((Object)this);
                exporter.setServiceInterface(RequestReplyExchanger.class);
                exporter.setServiceName(SERVICE_NAME_PREFIX + this.requestChannelName);
                exporter.afterPropertiesSet();
                this.exporter = exporter;
            }
        }
        super.onInit();
    }

    public Message<?> exchange(Message<?> message) {
        if (this.expectReply) {
            return this.sendAndReceiveMessage(message);
        }
        this.send(message);
        return null;
    }
}

