/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.security.config;

import java.util.Set;
import java.util.regex.Pattern;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.security.channel.ChannelSecurityInterceptor;
import org.springframework.integration.security.channel.ChannelSecurityMetadataSource;
import org.springframework.util.Assert;

public class ChannelSecurityInterceptorBeanPostProcessor
implements BeanPostProcessor {
    private final ChannelSecurityInterceptor interceptor;

    public ChannelSecurityInterceptorBeanPostProcessor(ChannelSecurityInterceptor interceptor) {
        Assert.notNull((Object)((Object)interceptor), (String)"interceptor must not be null");
        this.interceptor = interceptor;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ChannelSecurityMetadataSource channelSecurityMetadataSource = (ChannelSecurityMetadataSource)this.interceptor.obtainSecurityMetadataSource();
        if (bean instanceof MessageChannel && this.shouldProxy(beanName, (MessageChannel)bean, channelSecurityMetadataSource)) {
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)this.interceptor));
            return proxyFactory.getProxy();
        }
        return bean;
    }

    private boolean shouldProxy(String beanName, MessageChannel channel, ChannelSecurityMetadataSource channelSecurityMetadataSource) {
        Set<Pattern> patterns = channelSecurityMetadataSource.getPatterns();
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(beanName).matches()) continue;
            return true;
        }
        return false;
    }
}

