/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.sftp.session.JschLogger;
import org.springframework.integration.sftp.session.SftpSession;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSftpSessionFactory
implements SessionFactory {
    private volatile String host;
    private volatile int port = 22;
    private volatile String user;
    private volatile String password;
    private volatile String knownHosts;
    private volatile Resource privateKey;
    private volatile String privateKeyPassphrase;
    private volatile Properties sessionConfig;
    private final JSch jsch = new JSch();

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    public void setPrivateKey(Resource privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKeyPassphrase(String privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
    }

    public void setSessionConfig(Properties sessionConfig) {
        this.sessionConfig = sessionConfig;
    }

    public org.springframework.integration.file.remote.session.Session getSession() {
        Assert.hasText((String)this.host, (String)"host must not be empty");
        Assert.hasText((String)this.user, (String)"user must not be empty");
        Assert.isTrue((this.port >= 0 ? 1 : 0) != 0, (String)"port must be a positive number");
        Assert.isTrue((StringUtils.hasText((String)this.password) || this.privateKey != null ? 1 : 0) != 0, (String)"either a password or a private key is required");
        try {
            Session jschSession = this.initJschSession();
            SftpSession sftpSession = new SftpSession(jschSession);
            sftpSession.connect();
            return sftpSession;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to create SFTP Session", e);
        }
    }

    private Session initJschSession() throws Exception {
        JSch.setLogger((Logger)new JschLogger());
        if (this.port <= 0) {
            this.port = 22;
        }
        if (StringUtils.hasText((String)this.knownHosts)) {
            this.jsch.setKnownHosts(this.knownHosts);
        }
        if (this.privateKey != null) {
            String privateKeyFilePath = this.privateKey.getFile().getAbsolutePath();
            if (StringUtils.hasText((String)this.privateKeyPassphrase)) {
                this.jsch.addIdentity(privateKeyFilePath, this.privateKeyPassphrase);
            } else {
                this.jsch.addIdentity(privateKeyFilePath);
            }
        }
        Session jschSession = this.jsch.getSession(this.user, this.host, this.port);
        if (this.sessionConfig != null) {
            jschSession.setConfig(this.sessionConfig);
        }
        if (StringUtils.hasText((String)this.password)) {
            jschSession.setPassword(this.password);
        }
        jschSession.setUserInfo((UserInfo)new OptimisticUserInfoImpl(this.password));
        return jschSession;
    }

    private static class OptimisticUserInfoImpl
    implements UserInfo {
        private final String password;

        public OptimisticUserInfoImpl(String password) {
            this.password = password;
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public boolean promptPassword(String string) {
            return true;
        }

        public boolean promptYesNo(String string) {
            return true;
        }

        public void showMessage(String string) {
        }
    }
}

