/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Credentials;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.context.SingletonContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.smb.session.SmbConfig;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SmbShare
extends SmbFile {
    private static final Log logger = LogFactory.getLog(SmbShare.class);
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean open = new AtomicBoolean(false);
    private final AtomicBoolean closeContext = new AtomicBoolean(false);

    public SmbShare(SmbConfig _smbConfig) throws IOException {
        super(StringUtils.cleanPath((String)_smbConfig.validate().getUrl()), SingletonContext.getInstance().withCredentials((Credentials)new NtlmPasswordAuthenticator(_smbConfig.getDomain(), _smbConfig.getUsername(), _smbConfig.getPassword())));
    }

    public SmbShare(SmbConfig _smbConfig, CIFSContext _context) throws IOException {
        super(StringUtils.cleanPath((String)_smbConfig.validate().getUrl()), _context);
    }

    public SmbShare(SmbConfig _smbConfig, Properties _props) throws IOException {
        super(StringUtils.cleanPath((String)_smbConfig.validate().getUrl()), new BaseContext((Configuration)new PropertyConfiguration(_props)).withCredentials((Credentials)new NtlmPasswordAuthenticator(_smbConfig.getDomain(), _smbConfig.getUsername(), _smbConfig.getPassword())));
        this.closeContext.set(true);
    }

    public void init() throws IOException {
        boolean canRead;
        try {
            if (!this.exists()) {
                logger.info((Object)"SMB root directory does not exist. Creating it.");
                this.mkdirs();
            }
            canRead = this.canRead();
        }
        catch (SmbException _ex) {
            if (this.closeContext.get()) {
                try {
                    this.getContext().close();
                }
                catch (CIFSException e) {
                    logger.error((Object)("Unable to close share: " + this));
                }
            }
            throw new IOException("Unable to initialize share: " + this, _ex);
        }
        Assert.isTrue((boolean)canRead, (String)("Share is not accessible " + this));
        this.open.set(true);
    }

    boolean isOpened() {
        return this.open.get();
    }

    public void close() {
        this.lock.lock();
        try {
            this.open.set(false);
            if (this.closeContext.get()) {
                try {
                    this.getContext().close();
                }
                catch (CIFSException e) {
                    logger.error((Object)("Unable to close share: " + this));
                }
            }
            super.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

