/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.smb.session;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.util.Arrays;
import jcifs.SmbResource;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.smb.session.SmbConfig;
import org.springframework.integration.smb.session.SmbShare;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class SmbSession
implements Session<SmbFile> {
    private static final LogAccessor logger = new LogAccessor(SmbSession.class);
    private static final String FILE_SEPARATOR = FileSystems.getDefault().getSeparator();
    private static final String SMB_FILE_SEPARATOR = "/";
    private final SmbShare smbShare;

    SmbSession(String _host, int _port, String _domain, String _user, String _password, String _shareAndDir) throws IOException {
        this(new SmbShare(new SmbConfig(_host, _port, _domain, _user, _password, _shareAndDir)));
    }

    public SmbSession(SmbShare _smbShare) {
        Assert.notNull((Object)((Object)_smbShare), (String)"smbShare must not be null");
        this.smbShare = _smbShare;
    }

    public boolean remove(String _path) throws IOException {
        Assert.hasText((String)_path, (String)"path must not be empty");
        boolean removed = false;
        SmbFile removeFile = this.createSmbFileObject(_path);
        if (removeFile.exists()) {
            removeFile.delete();
            removed = true;
        }
        if (!removed) {
            logger.info(() -> "Could not remove non-existing resource [" + _path + "].");
        } else {
            logger.info(() -> "Successfully removed resource [" + _path + "].");
        }
        return removed;
    }

    public SmbFile[] list(String path) throws IOException {
        SmbFile remoteFile;
        String remoteFileName;
        String remotePath = StringUtils.trimTrailingCharacter((String)path, (char)'/');
        SmbFile[] files = null;
        int lastIndex = StringUtils.hasText((String)remotePath) ? remotePath.lastIndexOf(47) : 0;
        String string = remoteFileName = lastIndex > 0 ? remotePath.substring(lastIndex + 1) : null;
        if (StringUtils.hasText(remoteFileName) && (remoteFile = this.createSmbFileObject(remotePath)).isFile()) {
            files = new SmbFile[]{remoteFile};
        }
        if (files == null) {
            try {
                SmbFile smbDir = this.createSmbDirectoryObject(remotePath);
                if (!smbDir.exists()) {
                    logger.warn(() -> "Remote directory [" + remotePath + "] does not exist. Cannot list resources.");
                    return new SmbFile[0];
                }
                if (!smbDir.isDirectory()) {
                    throw new IOException("[" + remotePath + "] is not a directory. Cannot list resources.");
                }
                files = smbDir.listFiles();
            }
            catch (SmbException _ex) {
                throw new IOException("Failed to list in [" + remotePath + "].", _ex);
            }
        }
        SmbSession.logListedFiles(remotePath, files);
        return files;
    }

    public String[] listNames(String _path) throws IOException {
        try {
            SmbFile smbDir = this.createSmbDirectoryObject(_path);
            if (!smbDir.exists()) {
                logger.warn(() -> "Remote directory [" + _path + "] does not exist. Cannot list resources.");
                return new String[0];
            }
            if (!smbDir.isDirectory()) {
                throw new IOException("[" + _path + "] is not a directory. Cannot list resources.");
            }
            Object[] fileNames = smbDir.list();
            SmbSession.logListedFiles(_path, fileNames);
            return fileNames;
        }
        catch (SmbException _ex) {
            throw new IOException("Failed to list resources in [" + _path + "].", _ex);
        }
    }

    private static void logListedFiles(String _path, Object[] files) {
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Successfully listed " + files.length + " in [" + _path + "]: " + Arrays.toString(files)));
        } else {
            logger.info(() -> "Successfully listed " + files.length + " in [" + _path + "].");
        }
    }

    public void read(String _path, OutputStream _outputStream) throws IOException {
        Assert.hasText((String)_path, (String)"path must not be empty");
        Assert.notNull((Object)_outputStream, (String)"outputStream must not be null");
        try {
            SmbFile remoteFile = this.createSmbFileObject(_path);
            if (!remoteFile.isFile()) {
                throw new IOException("[" + _path + "] is not a file.");
            }
            FileCopyUtils.copy((InputStream)remoteFile.getInputStream(), (OutputStream)_outputStream);
        }
        catch (SmbException _ex) {
            throw new IOException("Failed to read resource [" + _path + "].", _ex);
        }
        logger.info(() -> "Successfully read resource [" + _path + "].");
    }

    public void write(InputStream _inputStream, String _path) throws IOException {
        Assert.notNull((Object)_inputStream, (String)"inputStream must not be empty");
        Assert.hasText((String)_path, (String)"path must not be null");
        try {
            this.mkdirs(_path);
            SmbFile targetFile = this.createSmbFileObject(_path);
            FileCopyUtils.copy((InputStream)_inputStream, (OutputStream)targetFile.getOutputStream());
        }
        catch (SmbException _ex) {
            throw new IOException("Failed to write resource [" + _path + "].", _ex);
        }
        logger.info(() -> "Successfully wrote remote file [" + _path + "].");
    }

    public SmbFile write(File _file, String _path) throws IOException {
        return this.writeAndClose(new FileInputStream(_file), _path);
    }

    public SmbFile write(byte[] _contents, String _path) throws IOException {
        return this.writeAndClose(new ByteArrayInputStream(_contents), _path);
    }

    public boolean mkdir(String _path) throws IOException {
        try {
            SmbFile dir = this.createSmbDirectoryObject(_path);
            if (!dir.exists()) {
                dir.mkdirs();
                logger.info(() -> "Successfully created remote directory [" + _path + "] in share [" + this.smbShare + "].");
            } else {
                logger.info(() -> "Remote directory [" + _path + "] exists in share [" + this.smbShare + "].");
            }
            return true;
        }
        catch (SmbException _ex) {
            throw new IOException("Failed to create directory [" + _path + "].", _ex);
        }
    }

    public boolean exists(String _path) throws IOException {
        return this.createSmbFileObject(_path).exists();
    }

    public boolean isFile(String _path) throws IOException {
        SmbFile resource = this.createSmbFileObject(_path);
        return resource.exists() && resource.isFile();
    }

    public boolean isDirectory(String _path) throws IOException {
        SmbFile resource = this.createSmbFileObject(_path);
        return resource.exists() && resource.isDirectory();
    }

    String mkdirs(String _path) throws IOException {
        int idxPath = _path.lastIndexOf(FILE_SEPARATOR);
        if (idxPath > -1) {
            String path = _path.substring(0, idxPath + 1);
            this.mkdir(path);
            return path;
        }
        return null;
    }

    public void rename(String _pathFrom, String _pathTo) throws IOException {
        try {
            SmbFile smbFileFrom = this.createSmbFileObject(_pathFrom);
            SmbFile smbFileTo = this.createSmbFileObject(_pathTo);
            if (smbFileTo.exists()) {
                smbFileTo.delete();
            }
            smbFileFrom.renameTo((SmbResource)smbFileTo);
        }
        catch (SmbException _ex) {
            throw new IOException("Failed to rename [" + _pathFrom + "] to [" + _pathTo + "].", _ex);
        }
        logger.info(() -> "Successfully renamed remote resource [" + _pathFrom + "] to [" + _pathTo + "].");
    }

    public void append(InputStream inputStream, String destination) throws IOException {
        SmbFile smbFile = this.createSmbFileObject(destination);
        SmbFileOutputStream fileOutputStream = new SmbFileOutputStream(smbFile, true);
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
    }

    public boolean rmdir(String directory) throws IOException {
        SmbFile dir = this.createSmbDirectoryObject(directory);
        try {
            dir.delete();
        }
        catch (SmbException ex) {
            logger.info(() -> "Failed to remove remote directory [" + directory + "]: " + ex);
            return false;
        }
        logger.info(() -> "Successfully removed remote directory [" + directory + "].");
        return true;
    }

    public InputStream readRaw(String source) throws IOException {
        SmbFile remoteFile = this.createSmbFileObject(source);
        if (!remoteFile.isFile()) {
            throw new IOException("[" + source + "] is not a file.");
        }
        return remoteFile.getInputStream();
    }

    public boolean finalizeRaw() {
        return true;
    }

    public Object getClientInstance() {
        return this.smbShare;
    }

    public void close() {
        this.smbShare.close();
    }

    public boolean isOpen() {
        if (!this.smbShare.isOpened()) {
            return false;
        }
        try {
            this.smbShare.listFiles();
        }
        catch (Exception _ex) {
            this.close();
        }
        return this.smbShare.isOpened();
    }

    SmbFile writeAndClose(InputStream _inputStream, String _path) throws IOException {
        this.write(_inputStream, _path);
        _inputStream.close();
        return this.createSmbFileObject(_path);
    }

    private SmbFile createSmbFileObject(String path, Boolean isDirectory) throws IOException {
        boolean appendFileSeparator;
        String cleanedPath = StringUtils.cleanPath((String)path);
        if (!StringUtils.hasText((String)cleanedPath)) {
            return this.smbShare;
        }
        SmbFile smbFile = new SmbFile((SmbResource)this.smbShare, cleanedPath);
        boolean bl = appendFileSeparator = !cleanedPath.endsWith(SMB_FILE_SEPARATOR);
        if (appendFileSeparator) {
            try {
                appendFileSeparator = smbFile.isDirectory() || isDirectory != null && isDirectory != false;
            }
            catch (SmbException ex) {
                appendFileSeparator = false;
            }
        }
        if (appendFileSeparator) {
            smbFile = this.createSmbFileObject(cleanedPath + SMB_FILE_SEPARATOR);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((CharSequence)("Created new " + SmbFile.class.getName() + "[" + smbFile + "] for path [" + path + "]."));
        }
        return smbFile;
    }

    public SmbFile createSmbFileObject(String _path) throws IOException {
        return this.createSmbFileObject(_path, null);
    }

    public SmbFile createSmbDirectoryObject(String _path) throws IOException {
        return this.createSmbFileObject(_path, true);
    }

    public String getHostPort() {
        URL url = this.smbShare.getURL();
        return url.getHost() + ":" + url.getPort();
    }
}

