/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

@Deprecated
public class Log4jLevelAdjuster
implements MethodRule {
    private static final Log logger = LogFactory.getLog(Log4jLevelAdjuster.class);
    private final Class<?>[] classes;
    private final Level level;
    private final String[] categories;

    public Log4jLevelAdjuster(Level level, Class<?> ... classes) {
        this.level = level;
        this.classes = classes;
        this.categories = new String[0];
    }

    public Log4jLevelAdjuster(Level level, String ... categories) {
        this.level = level;
        this.classes = new Class[0];
        LinkedHashSet<String> cats = new LinkedHashSet<String>(Arrays.asList(categories));
        cats.add(this.getClass().getPackage().getName());
        this.categories = new ArrayList<String>(cats).toArray(new String[cats.size()]);
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                HashMap<Class, Level> oldLevels = new HashMap<Class, Level>();
                for (Class cls : Log4jLevelAdjuster.this.classes) {
                    oldLevels.put(cls, LogManager.getLogger((Class)cls).getEffectiveLevel());
                    LogManager.getLogger((Class)cls).setLevel(Log4jLevelAdjuster.this.level);
                }
                HashMap<String, Level> oldCatLevels = new HashMap<String, Level>();
                for (String string : Log4jLevelAdjuster.this.categories) {
                    oldCatLevels.put(string, LogManager.getLogger((String)string).getEffectiveLevel());
                    LogManager.getLogger((String)string).setLevel(Log4jLevelAdjuster.this.level);
                }
                logger.debug((Object)("++++++++++++++++++++++++++++ Overridden log level setting for: " + Arrays.asList(Log4jLevelAdjuster.this.classes) + " and " + Arrays.asList(Log4jLevelAdjuster.this.categories) + " for test " + method.getName()));
                try {
                    base.evaluate();
                }
                finally {
                    logger.debug((Object)("++++++++++++++++++++++++++++ Restoring log level setting for: " + Arrays.asList(Log4jLevelAdjuster.this.classes) + " and " + Arrays.asList(Log4jLevelAdjuster.this.categories) + " for test " + method.getName()));
                    for (Class clazz : Log4jLevelAdjuster.this.classes) {
                        LogManager.getLogger((Class)clazz).setLevel((Level)oldLevels.get(clazz));
                    }
                    for (String string : Log4jLevelAdjuster.this.categories) {
                        LogManager.getLogger((String)string).setLevel((Level)oldCatLevels.get(string));
                    }
                }
            }
        };
    }
}

