/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class TestUtils {
    public static Object getPropertyValue(Object root, String propertyPath) {
        Object value = null;
        DirectFieldAccessor accessor = new DirectFieldAccessor(root);
        String[] tokens = propertyPath.split("\\.");
        for (int i = 0; i < tokens.length; ++i) {
            value = accessor.getPropertyValue(tokens[i]);
            if (value == null) {
                if (i == tokens.length - 1) {
                    return null;
                }
                throw new IllegalArgumentException("intermediate property '" + tokens[i] + "' is null");
            }
            accessor = new DirectFieldAccessor(value);
        }
        return value;
    }

    public static <T> T getPropertyValue(Object root, String propertyPath, Class<T> type) {
        Object value = TestUtils.getPropertyValue(root, propertyPath);
        if (value != null) {
            Assert.isAssignable(type, value.getClass());
        }
        return (T)value;
    }

    public static TestApplicationContext createTestApplicationContext() {
        TestApplicationContext context = new TestApplicationContext();
        MessagePublishingErrorHandler errorHandler = new MessagePublishingErrorHandler(context);
        ThreadPoolTaskScheduler scheduler = TestUtils.createTaskScheduler(10);
        scheduler.setErrorHandler((ErrorHandler)errorHandler);
        TestUtils.registerBean("taskScheduler", scheduler, (BeanFactory)context);
        TestUtils.registerBean("integrationConversionService", new DefaultFormattingConversionService(), (BeanFactory)context);
        return context;
    }

    public static ThreadPoolTaskScheduler createTaskScheduler(int poolSize) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(poolSize);
        scheduler.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        scheduler.afterPropertiesSet();
        return scheduler;
    }

    private static void registerBean(String beanName, Object bean, BeanFactory beanFactory) {
        Assert.notNull((Object)beanName, (String)"bean name must not be null");
        ConfigurableListableBeanFactory configurableListableBeanFactory = null;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
        } else if (beanFactory instanceof GenericApplicationContext) {
            configurableListableBeanFactory = ((GenericApplicationContext)beanFactory).getBeanFactory();
        }
        if (bean instanceof BeanNameAware) {
            ((BeanNameAware)bean).setBeanName(beanName);
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory(beanFactory);
        }
        if (bean instanceof InitializingBean) {
            try {
                ((InitializingBean)bean).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new FatalBeanException("failed to register bean with test context", (Throwable)e);
            }
        }
        configurableListableBeanFactory.registerSingleton(beanName, bean);
    }

    public static Properties locateComponentInHistory(List<Properties> history, String componentName, int startingIndex) {
        Assert.notNull(history, (String)"'history' must not be null");
        Assert.isTrue((boolean)StringUtils.hasText((String)componentName), (String)"'componentName' must be provided");
        Assert.isTrue((startingIndex < history.size() ? 1 : 0) != 0, (String)"'startingIndex' can not be greater then size of history");
        Properties component = null;
        for (int i = startingIndex; i < history.size(); ++i) {
            Properties properties = history.get(i);
            if (!componentName.equals(properties.get("name"))) continue;
            component = properties;
            break;
        }
        return component;
    }

    public static String applySystemFileSeparator(String s) {
        return s.replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    private static class MessagePublishingErrorHandler
    implements ErrorHandler {
        private final Log logger = LogFactory.getLog(this.getClass());
        private final TestApplicationContext context;

        MessagePublishingErrorHandler(TestApplicationContext ctx) {
            this.context = ctx;
        }

        public void handleError(Throwable t) {
            boolean sent;
            block7: {
                MessageChannel errorChannel = this.resolveErrorChannel(t);
                sent = false;
                if (errorChannel != null) {
                    try {
                        sent = errorChannel.send((Message)new ErrorMessage(t), 10000L);
                    }
                    catch (Throwable errorDeliveryError) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn((Object)"Error message was not delivered.", errorDeliveryError);
                        }
                        if (!(errorDeliveryError instanceof Error)) break block7;
                        throw (Error)errorDeliveryError;
                    }
                }
            }
            if (!sent && this.logger.isErrorEnabled()) {
                Message failedMessage;
                Message message = failedMessage = t instanceof MessagingException ? ((MessagingException)t).getFailedMessage() : null;
                if (failedMessage != null) {
                    this.logger.error((Object)("failure occurred in messaging task with message: " + failedMessage), t);
                } else {
                    this.logger.error((Object)"failure occurred in messaging task", t);
                }
            }
        }

        private MessageChannel resolveErrorChannel(Throwable t) {
            if (t instanceof MessagingException) {
                Message failedMessage = ((MessagingException)t).getFailedMessage();
                Object errorChannelHeader = failedMessage.getHeaders().getErrorChannel();
                if (errorChannelHeader instanceof MessageChannel) {
                    return (MessageChannel)errorChannelHeader;
                }
                Assert.isInstanceOf(String.class, (Object)errorChannelHeader, (String)("Unsupported error channel header type. Expected MessageChannel or String, but actual type is [" + errorChannelHeader.getClass() + "]"));
                return (MessageChannel)this.context.getBean((String)errorChannelHeader, MessageChannel.class);
            }
            return null;
        }
    }

    public static class TestApplicationContext
    extends GenericApplicationContext {
        TestApplicationContext() {
        }

        public void registerChannel(String channelName, MessageChannel channel) {
            String componentName = this.getComponentNameIfNamed(channel);
            if (componentName != null) {
                if (channelName == null) {
                    channelName = componentName;
                } else {
                    Assert.isTrue((boolean)componentName.equals(channelName), (String)"channel name has already been set with a conflicting value");
                }
            }
            TestUtils.registerBean(channelName, channel, (BeanFactory)this);
        }

        public void registerEndpoint(String endpointName, Object endpoint) {
            TestUtils.registerBean(endpointName, endpoint, (BeanFactory)this);
        }

        public void registerBean(String beanName, Object bean) {
            TestUtils.registerBean(beanName, bean, (BeanFactory)this);
        }

        private String getComponentNameIfNamed(MessageChannel channel) {
            Set interfaces = ClassUtils.getAllInterfacesAsSet((Object)channel);
            AtomicReference componentName = new AtomicReference();
            for (Class intface : interfaces) {
                if (!"org.springframework.integration.support.context.NamedComponent".equals(intface.getName())) continue;
                ReflectionUtils.doWithMethods(channel.getClass(), method -> {
                    try {
                        componentName.set((String)method.invoke((Object)channel, new Object[0]));
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }, method -> method.getName().equals("getComponentName"));
                break;
            }
            return (String)componentName.get();
        }
    }
}

