/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.core;

import org.springframework.util.StringUtils;
import twitter4j.TwitterException;

public class TwitterOperationException
extends RuntimeException {
    private int twitterStatusCode = -1;

    public TwitterOperationException() {
        this(null, null);
    }

    public TwitterOperationException(String description) {
        this(description, null);
    }

    public TwitterOperationException(Throwable throwable) {
        this(null, throwable);
    }

    public TwitterOperationException(String description, Throwable throwable) {
        super(TwitterOperationException.formatDescription(description, throwable), throwable);
        if (throwable instanceof TwitterException) {
            this.twitterStatusCode = ((TwitterException)throwable).getStatusCode();
        }
    }

    public int getTwitterStatusCode() {
        return this.twitterStatusCode;
    }

    private static String formatDescription(String description, Throwable throwable) {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.hasText((String)description)) {
            buffer.append(description + " ");
        }
        if (throwable != null && throwable instanceof TwitterException) {
            TwitterException te = (TwitterException)throwable;
            String message = te.getMessage();
            if (StringUtils.hasText((String)message)) {
                buffer.append("Detailed Error: ");
                if (message.contains("{")) {
                    buffer.append(message.substring(0, message.indexOf("{")));
                } else {
                    buffer.append(message);
                }
            }
            buffer.append("For more information about this exception please visit the following Twitter website: http://apiwiki.twitter.com/w/page/22554652/HTTP-Response-Codes-and-Errors");
        }
        return buffer.toString();
    }
}

