/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.outbound;

import org.springframework.integration.Message;
import org.springframework.integration.MessageHandlingException;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.twitter.core.Tweet;
import org.springframework.integration.twitter.core.TwitterOperations;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusUpdatingMessageHandler
extends AbstractMessageHandler {
    private final TwitterOperations twitterOperations;

    public StatusUpdatingMessageHandler(TwitterOperations twitterOperations) {
        Assert.notNull((Object)twitterOperations, (String)"twitterOperations must not be null");
        this.twitterOperations = twitterOperations;
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object payload = message.getPayload();
        String statusText = null;
        if (payload instanceof Tweet) {
            statusText = ((Tweet)payload).getText();
        } else if (payload instanceof String) {
            statusText = (String)payload;
        } else {
            throw new MessageHandlingException(message, "Unsupported payload type '" + payload.getClass().getName() + "'");
        }
        this.twitterOperations.updateStatus(statusText);
    }
}

