/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.twitter.inbound;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.store.MetadataStore;
import org.springframework.integration.store.SimpleMetadataStore;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.social.twitter.api.DirectMessage;
import org.springframework.social.twitter.api.Tweet;
import org.springframework.social.twitter.api.Twitter;
import org.springframework.social.twitter.api.UserOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTwitterMessageSource<T>
extends IntegrationObjectSupport
implements MessageSource {
    private volatile long lastPollForTweet;
    private volatile MetadataStore metadataStore;
    private volatile String metadataKey;
    private final Queue<T> tweets = new LinkedBlockingQueue<T>();
    private volatile int prefetchThreshold = 0;
    private volatile long lastEnqueuedId = -1L;
    private volatile long lastProcessedId = -1L;
    private final Twitter twitter;
    private final TweetComparator tweetComparator = new TweetComparator();
    private final Object lastEnqueuedIdMonitor = new Object();

    public AbstractTwitterMessageSource(Twitter twitter) {
        Assert.notNull((Object)twitter, (String)"twitter must not be null");
        this.twitter = twitter;
    }

    protected Twitter getTwitter() {
        return this.twitter;
    }

    protected void onInit() throws Exception {
        super.onInit();
        if (this.metadataStore == null) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.metadataStore = IntegrationContextUtils.getMetadataStore((BeanFactory)beanFactory);
            }
            if (this.metadataStore == null) {
                this.metadataStore = new SimpleMetadataStore();
            }
        }
        StringBuilder metadataKeyBuilder = new StringBuilder();
        if (StringUtils.hasText((String)this.getComponentType())) {
            metadataKeyBuilder.append(this.getComponentType() + ".");
        }
        if (StringUtils.hasText((String)this.getComponentName())) {
            metadataKeyBuilder.append(this.getComponentName() + ".");
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " has no name. MetadataStore key might not be unique."));
        }
        UserOperations userOperations = this.twitter.userOperations();
        if (userOperations != null) {
            String profileId = String.valueOf(userOperations.getProfileId());
            if (profileId != null) {
                metadataKeyBuilder.append(profileId);
            }
            this.metadataKey = metadataKeyBuilder.toString();
            String lastId = this.metadataStore.get(this.metadataKey);
            if (StringUtils.hasText((String)lastId)) {
                this.lastEnqueuedId = this.lastProcessedId = Long.parseLong(lastId);
            }
        }
    }

    public Message<?> receive() {
        T tweet = this.tweets.poll();
        if (tweet == null) {
            long currentTime = System.currentTimeMillis();
            long elapsedTime = currentTime - this.lastPollForTweet;
            if (elapsedTime < 15000L) {
                return null;
            }
            this.refreshTweetQueueIfNecessary();
            tweet = this.tweets.poll();
            this.lastPollForTweet = currentTime;
        }
        if (tweet != null) {
            this.lastProcessedId = this.getIdForTweet(tweet);
            this.metadataStore.put(this.metadataKey, String.valueOf(this.lastProcessedId));
            return MessageBuilder.withPayload(tweet).build();
        }
        return null;
    }

    private void enqueueAll(List<T> tweets) {
        Collections.sort(tweets, this.tweetComparator);
        for (T tweet : tweets) {
            this.enqueue(tweet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(T tweet) {
        Object object = this.lastEnqueuedIdMonitor;
        synchronized (object) {
            long id = this.getIdForTweet(tweet);
            if (id > this.lastEnqueuedId) {
                this.tweets.add(tweet);
                this.lastEnqueuedId = id;
            }
        }
    }

    private void refreshTweetQueueIfNecessary() {
        try {
            List<T> tweets;
            if (this.tweets.size() <= this.prefetchThreshold && !CollectionUtils.isEmpty(tweets = this.pollForTweets(this.lastEnqueuedId))) {
                this.enqueueAll(tweets);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("failed while polling Twitter", (Throwable)e);
        }
    }

    protected abstract List<T> pollForTweets(long var1);

    private long getIdForTweet(T twitterMessage) {
        if (twitterMessage instanceof Tweet) {
            return ((Tweet)twitterMessage).getId();
        }
        if (twitterMessage instanceof DirectMessage) {
            return ((DirectMessage)twitterMessage).getId();
        }
        throw new IllegalArgumentException("Unsupported Twitter object: " + twitterMessage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TweetComparator
    implements Comparator<T> {
        private TweetComparator() {
        }

        @Override
        public int compare(T tweet1, T tweet2) {
            if (tweet1 instanceof Tweet && tweet2 instanceof Tweet) {
                Tweet t1 = (Tweet)tweet1;
                Tweet t2 = (Tweet)tweet2;
                Date t1CreatedAt = t1.getCreatedAt();
                Date t2CreatedAt = t2.getCreatedAt();
                Assert.notNull((Object)t1CreatedAt, (String)"Tweet is missing 'createdAt' date. Cannot compare.");
                Assert.notNull((Object)t2CreatedAt, (String)"Tweet is missing 'createdAt' date. Cannot compare.");
                return t1CreatedAt.compareTo(t2CreatedAt);
            }
            if (tweet1 instanceof DirectMessage && tweet2 instanceof DirectMessage) {
                DirectMessage d1 = (DirectMessage)tweet1;
                DirectMessage d2 = (DirectMessage)tweet2;
                Date d1CreatedAt = d1.getCreatedAt();
                Date d2CreatedAt = d2.getCreatedAt();
                Assert.notNull((Object)d1CreatedAt, (String)"DirectMessage is missing 'createdAt' date. Cannot compare.");
                Assert.notNull((Object)d2CreatedAt, (String)"DirectMessage is missing 'createdAt' date. Cannot compare.");
                return d1CreatedAt.compareTo(d2CreatedAt);
            }
            throw new IllegalArgumentException("Uncomparable Twitter objects: " + tweet1 + " and " + tweet2);
        }
    }
}

