/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import org.springframework.integration.ws.AbstractWebServiceOutboundGateway;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.client.support.destination.DestinationProvider;

public class MarshallingWebServiceOutboundGateway
extends AbstractWebServiceOutboundGateway {
    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, Unmarshaller unmarshaller, WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.notNull((Object)unmarshaller, (String)"unmarshaller must not be null");
        this.getWebServiceTemplate().setMarshaller(marshaller);
        this.getWebServiceTemplate().setUnmarshaller(unmarshaller);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, Unmarshaller unmarshaller) {
        this(destinationProvider, marshaller, unmarshaller, null);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller, WebServiceMessageFactory messageFactory) {
        super(destinationProvider, messageFactory);
        Assert.notNull((Object)marshaller, (String)"marshaller must not be null");
        Assert.isInstanceOf(Unmarshaller.class, (Object)marshaller, (String)("Marshaller [" + marshaller + "] does not implement the Unmarshaller interface. " + "Please set an Unmarshaller explicitly by using the " + ((Object)((Object)this)).getClass().getName() + "(DestinationProvider destinationProvider, Marshaller marshaller, Unmarshaller unmarshaller) constructor."));
        this.getWebServiceTemplate().setMarshaller(marshaller);
        this.getWebServiceTemplate().setUnmarshaller((Unmarshaller)marshaller);
    }

    public MarshallingWebServiceOutboundGateway(DestinationProvider destinationProvider, Marshaller marshaller) {
        this(destinationProvider, marshaller, (WebServiceMessageFactory)null);
    }

    protected Object doHandle(Object requestPayload, WebServiceMessageCallback requestCallback) {
        return this.getWebServiceTemplate().marshalSendAndReceive(requestPayload, requestCallback);
    }
}

