/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractRouterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.xml.config.XPathExpressionParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XPathRouterParser
extends AbstractRouterParser {
    private XPathExpressionParser xpathParser = new XPathExpressionParser();

    protected BeanDefinition doParseRouter(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder xpathRouterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.xml.router.XPathRouter");
        NodeList xPathExpressionNodes = element.getElementsByTagNameNS(element.getNamespaceURI(), "xpath-expression");
        Assert.isTrue((xPathExpressionNodes.getLength() <= 1 ? 1 : 0) != 0, (String)"At most one xpath-expression child may be specified.");
        String xPathExpressionRef = element.getAttribute("xpath-expression-ref");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)xpathRouterBuilder, (Element)element, (String)"evaluate-as-string");
        boolean xPathExpressionChildPresent = xPathExpressionNodes.getLength() == 1;
        boolean xPathReferencePresent = StringUtils.hasText((String)xPathExpressionRef);
        Assert.isTrue((boolean)(xPathExpressionChildPresent ^ xPathReferencePresent), (String)"Exactly one of 'xpath-expression' or 'xpath-expression-ref' is required.");
        if (xPathExpressionChildPresent) {
            BeanDefinition beanDefinition = this.xpathParser.parse((Element)xPathExpressionNodes.item(0), parserContext);
            xpathRouterBuilder.addConstructorArgValue((Object)beanDefinition);
        } else {
            xpathRouterBuilder.addConstructorArgReference(xPathExpressionRef);
        }
        return xpathRouterBuilder.getBeanDefinition();
    }
}

