/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.result;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.springframework.integration.MessagingException;
import org.springframework.integration.xml.result.ResultFactory;

public class DomResultFactory
implements ResultFactory {
    private final DocumentBuilderFactory documentBuilderFactory;

    public DomResultFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    public DomResultFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        this.documentBuilderFactory = factory;
    }

    @Override
    public synchronized Result createResult(Object payload) {
        try {
            return new DOMResult(this.getNewDocumentBuilder().newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException("failed to create Result for payload type [" + payload.getClass().getName() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = this.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            return this.documentBuilderFactory.newDocumentBuilder();
        }
    }
}

