/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.selector;

import java.util.Map;
import org.springframework.integration.Message;
import org.springframework.integration.xml.selector.AbstractXPathMessageSelector;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Node;

public class StringValueTestXPathMessageSelector
extends AbstractXPathMessageSelector {
    private final String valueToTestFor;
    private volatile boolean caseSensitive = true;

    public StringValueTestXPathMessageSelector(String expression, Map<String, String> namespaces, String valueToTestFor) {
        super(expression, namespaces);
        this.valueToTestFor = valueToTestFor;
    }

    public StringValueTestXPathMessageSelector(String expression, String prefix, String namespace, String valueToTestFor) {
        super(expression, prefix, namespace);
        this.valueToTestFor = valueToTestFor;
    }

    public StringValueTestXPathMessageSelector(String expression, String valueToTestFor) {
        super(expression);
        this.valueToTestFor = valueToTestFor;
    }

    public StringValueTestXPathMessageSelector(XPathExpression expression, String valueToTestFor) {
        super(expression);
        this.valueToTestFor = valueToTestFor;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean accept(Message<?> message) {
        Node nodeToTest = this.getConverter().convertToNode(message.getPayload());
        String xPathResult = this.getXPathExpresion().evaluateAsString(nodeToTest);
        if (this.caseSensitive) {
            return this.valueToTestFor.equals(xPathResult);
        }
        return this.valueToTestFor.equalsIgnoreCase(xPathResult);
    }
}

