/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class XmppConnectionParser
extends AbstractSingleBeanDefinitionParser {
    private static String[] connectionFactoryAttributes = new String[]{"user", "password", "resource", "subscription-mode"};

    protected String getBeanClassName(Element element) {
        return "org.springframework.integration.xmpp.config.XmppConnectionFactoryBean";
    }

    protected boolean shouldGenerateIdAsFallback() {
        return false;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String serviceName = element.getAttribute("service-name");
        String host = element.getAttribute("host");
        String port = element.getAttribute("port");
        BeanDefinitionBuilder connectionConfigurationBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.jivesoftware.smack.ConnectionConfiguration");
        if (StringUtils.hasText((String)host)) {
            Assert.hasLength((String)port, (String)"Port must be provided if 'host' is specified");
            connectionConfigurationBuilder.addConstructorArgValue((Object)host);
            connectionConfigurationBuilder.addConstructorArgValue((Object)port);
        } else {
            Assert.hasText((String)serviceName, (String)"'serviceName' is requuired if 'host' is not provided");
        }
        if (StringUtils.hasText((String)serviceName)) {
            connectionConfigurationBuilder.addConstructorArgValue((Object)serviceName);
        }
        for (String attribute : connectionFactoryAttributes) {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)attribute);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        builder.addConstructorArgValue((Object)connectionConfigurationBuilder.getBeanDefinition());
    }
}

