/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zip.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.springframework.integration.zip.transformer.AbstractZipTransformer;
import org.springframework.integration.zip.transformer.SpringZipUtils;
import org.springframework.integration.zip.transformer.ZipResultType;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.ZipUtil;

public class UnZipTransformer
extends AbstractZipTransformer {
    private volatile boolean expectSingleResult = false;

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object doZipTransform(final Message<?> message) {
        void var3_9;
        InputStream inputStream;
        block15: {
            Object payload = message.getPayload();
            inputStream = null;
            try {
                if (payload instanceof File) {
                    File filePayload = (File)payload;
                    if (filePayload.isDirectory()) {
                        throw new UnsupportedOperationException("Cannot unzip a directory: " + filePayload.getAbsolutePath());
                    }
                    if (!SpringZipUtils.isValid(filePayload)) {
                        throw new IllegalStateException("Not a zip file: " + filePayload.getAbsolutePath());
                    }
                    inputStream = new FileInputStream(filePayload);
                } else if (payload instanceof InputStream) {
                    inputStream = (InputStream)payload;
                } else {
                    if (!(payload instanceof byte[])) throw new IllegalArgumentException("Unsupported payload type '" + payload.getClass().getSimpleName() + "'. The only supported payload types are java.io.File, byte[] and java.io.InputStream");
                    inputStream = new ByteArrayInputStream((byte[])payload);
                }
                final TreeMap uncompressedData = new TreeMap();
                ZipUtil.iterate((InputStream)inputStream, (ZipEntryCallback)new ZipEntryCallback(){

                    public void process(InputStream zipEntryInputStream, ZipEntry zipEntry) throws IOException {
                        String zipEntryName = zipEntry.getName();
                        long zipEntryTime = zipEntry.getTime();
                        long zipEntryCompressedSize = zipEntry.getCompressedSize();
                        String type = zipEntry.isDirectory() ? "directory" : "file";
                        UnZipTransformer.this.logger.info(() -> String.format("Unpacking Zip Entry - Name: '%s',Time: '%s', Compressed Size: '%s', Type: '%s'", zipEntryName, zipEntryTime, zipEntryCompressedSize, type));
                        if (ZipResultType.FILE.equals((Object)UnZipTransformer.this.zipResultType)) {
                            File destinationFile = this.checkPath(message, zipEntryName);
                            if (zipEntry.isDirectory()) {
                                destinationFile.mkdirs();
                            } else {
                                UnZipTransformer.mkDirOfAncestorDirectories(destinationFile);
                                SpringZipUtils.copy(zipEntryInputStream, destinationFile);
                                uncompressedData.put(zipEntryName, destinationFile);
                            }
                        } else if (ZipResultType.BYTE_ARRAY.equals((Object)UnZipTransformer.this.zipResultType)) {
                            if (!zipEntry.isDirectory()) {
                                this.checkPath(message, zipEntryName);
                                byte[] data = IOUtils.toByteArray((InputStream)zipEntryInputStream);
                                uncompressedData.put(zipEntryName, data);
                            }
                        } else {
                            throw new IllegalStateException("Unsupported zipResultType: " + UnZipTransformer.this.zipResultType);
                        }
                    }

                    public File checkPath(Message<?> message2, String zipEntryName) throws IOException {
                        File tempDir = new File(UnZipTransformer.this.workDirectory, message2.getHeaders().getId().toString());
                        tempDir.mkdirs();
                        File destinationFile = new File(tempDir, zipEntryName);
                        if (!destinationFile.getCanonicalPath().startsWith(tempDir.getCanonicalPath() + File.separator)) {
                            throw new ZipException("The file " + zipEntryName + " is trying to leave the target output directory of " + UnZipTransformer.this.workDirectory);
                        }
                        return destinationFile;
                    }
                });
                if (uncompressedData.isEmpty()) {
                    this.logger.warn(() -> "No data unzipped from payload with message Id " + message.getHeaders().getId());
                    Object var3_6 = null;
                } else if (this.expectSingleResult) {
                    if (uncompressedData.size() != 1) throw new MessagingException(message, String.format("The UnZip operation extracted %s result objects but expectSingleResult was 'true'.", uncompressedData.size()));
                    Object v = uncompressedData.values().iterator().next();
                } else {
                    TreeMap treeMap = uncompressedData;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                if (!(payload instanceof File)) break block15;
                File filePayload = (File)payload;
                if (this.deleteFiles && !filePayload.delete()) {
                    this.logger.warn(() -> "failed to delete File '" + filePayload + "'");
                }
            }
            catch (FileNotFoundException ex) {
                try {
                    throw new UncheckedIOException(ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return var3_9;
    }

    private static void mkDirOfAncestorDirectories(File destinationFile) {
        File parentDirectory = destinationFile.getParentFile();
        if (parentDirectory != null) {
            parentDirectory.mkdirs();
        }
    }
}

