/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.config;

import java.io.Closeable;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;

public class CuratorFrameworkFactoryBean
implements FactoryBean<CuratorFramework>,
SmartLifecycle {
    private final Object lifecycleLock = new Object();
    private final CuratorFramework client;
    private volatile boolean autoStartup = true;
    private volatile boolean running;
    private volatile int phase;

    public CuratorFrameworkFactoryBean(String connectionString) {
        this(connectionString, (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
    }

    public CuratorFrameworkFactoryBean(String connectionString, RetryPolicy retryPolicy) {
        Assert.notNull((Object)connectionString, (String)"'connectionString' cannot be null");
        Assert.notNull((Object)retryPolicy, (String)"'retryPolicy' cannot be null");
        this.client = CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)retryPolicy);
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.running) {
                if (this.client != null) {
                    this.client.start();
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.running && this.client.getState().equals((Object)CuratorFrameworkState.STARTED)) {
                CloseableUtils.closeQuietly((Closeable)this.client);
            }
        }
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    public CuratorFramework getObject() throws Exception {
        return this.client;
    }

    public Class<?> getObjectType() {
        return CuratorFramework.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

