/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.leader;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.util.StringUtils;

public class LeaderInitiator
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(LeaderInitiator.class);
    private static final String DEFAULT_NAMESPACE = "/spring-integration/leader/";
    private final CuratorFramework client;
    private final Candidate candidate;
    private final Object lifecycleMonitor = new Object();
    private volatile LeaderSelector leaderSelector;
    private volatile boolean autoStartup = true;
    private volatile int phase;
    private volatile boolean running;
    private final String namespace;
    private volatile LeaderEventPublisher leaderEventPublisher;

    public LeaderInitiator(CuratorFramework client, Candidate candidate) {
        this(client, candidate, DEFAULT_NAMESPACE);
    }

    public LeaderInitiator(CuratorFramework client, Candidate candidate, String namespace) {
        this.client = client;
        this.candidate = candidate;
        this.namespace = namespace;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running) {
                if (this.client.getState() != CuratorFrameworkState.STARTED) {
                    this.client.start();
                }
                this.leaderSelector = new LeaderSelector(this.client, this.buildLeaderPath(), (LeaderSelectorListener)new LeaderListener());
                this.leaderSelector.setId(this.candidate.getId());
                this.leaderSelector.autoRequeue();
                this.leaderSelector.start();
                this.running = true;
                logger.debug((Object)"Started LeaderInitiator");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                this.leaderSelector.close();
                this.running = false;
                logger.debug((Object)"Stopped LeaderInitiator");
            }
        }
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        this.leaderEventPublisher = leaderEventPublisher;
    }

    private String buildLeaderPath() {
        String ns;
        String string = ns = StringUtils.hasText((String)this.namespace) ? this.namespace : DEFAULT_NAMESPACE;
        if (!ns.startsWith("/")) {
            ns = "/" + ns;
        }
        if (!ns.endsWith("/")) {
            ns = ns + "/";
        }
        return String.format(ns + "%s", this.candidate.getRole());
    }

    class CuratorContext
    implements Context {
        CuratorContext() {
        }

        public boolean isLeader() {
            return LeaderInitiator.this.leaderSelector.hasLeadership();
        }

        public void yield() {
            LeaderInitiator.this.leaderSelector.interruptLeadership();
        }

        public String toString() {
            return String.format("CuratorContext{role=%s, id=%s, isLeader=%s}", LeaderInitiator.this.candidate.getRole(), LeaderInitiator.this.candidate.getId(), this.isLeader());
        }
    }

    class LeaderListener
    extends LeaderSelectorListenerAdapter {
        LeaderListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void takeLeadership(CuratorFramework framework) throws Exception {
            CuratorContext context = new CuratorContext();
            try {
                LeaderInitiator.this.candidate.onGranted((Context)context);
                if (LeaderInitiator.this.leaderEventPublisher != null) {
                    LeaderInitiator.this.leaderEventPublisher.publishOnGranted((Object)LeaderInitiator.this, (Context)context, LeaderInitiator.this.candidate.getRole());
                }
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                LeaderInitiator.this.candidate.onRevoked((Context)context);
                if (LeaderInitiator.this.leaderEventPublisher != null) {
                    LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)context, LeaderInitiator.this.candidate.getRole());
                }
            }
        }
    }
}

