/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.core;

import java.lang.reflect.Method;
import org.springframework.config.java.annotation.aop.ScopedProxy;
import org.springframework.config.java.core.AbstractBeanMethodProcessor;
import org.springframework.config.java.core.StandardBeanMethodProcessor;
import org.springframework.config.java.valuesource.ValueResolutionException;
import org.springframework.util.Assert;

public class ScopedProxyMethodProcessor
extends AbstractBeanMethodProcessor {
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";
    private final StandardBeanMethodProcessor delegate;

    public ScopedProxyMethodProcessor(StandardBeanMethodProcessor delegate) {
        super(ScopedProxy.class);
        Assert.notNull((Object)delegate, (String)"BeanMethodProcessor argument is required");
        this.delegate = delegate;
    }

    private ScopedProxyMethodProcessor() {
        super(ScopedProxy.class);
        this.delegate = null;
    }

    public String processMethod(Method m) throws ValueResolutionException {
        String beanToReturn = this.delegate.getBeanName(m);
        String scopedBean = ScopedProxyMethodProcessor.resolveHiddenScopedProxyBeanName(beanToReturn);
        if (this.delegate.isCurrentlyInCreation(scopedBean)) {
            beanToReturn = scopedBean;
        }
        return beanToReturn;
    }

    public static boolean isScopedProxyMethod(Method candidateMethod) {
        return new ScopedProxyMethodProcessor().understands(candidateMethod);
    }

    public static String resolveHiddenScopedProxyBeanName(String originalBeanName) {
        Assert.hasText((String)originalBeanName);
        return TARGET_NAME_PREFIX.concat(originalBeanName);
    }
}

