/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.config.java.process.ConfigurationListenerSupport;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.core.Ordered;

abstract class AbstractAopConfigurationListener
extends ConfigurationListenerSupport {
    private Map<String, Pointcut> pointcuts = new HashMap<String, Pointcut>();

    AbstractAopConfigurationListener() {
    }

    protected void addAdvice(String adviceName, Pointcut pc, ConfigurationProcessor cp) {
        this.pointcuts.put(adviceName, pc);
    }

    protected void addAdvice(String adviceName, Pointcut pc, Advice advice, ConfigurationProcessor cp) {
        cp.registerSingleton(adviceName, advice, true);
        this.pointcuts.put(adviceName, pc);
    }

    public boolean processBeanMethodReturnValue(BeanFactory childBeanFactory, Object originallyCreatedBean, Method method, ProxyFactory pf) {
        int added = 0;
        for (String adviceName : this.pointcuts.keySet()) {
            Pointcut pc = this.pointcuts.get(adviceName);
            if (!AopUtils.canApply((Pointcut)pc, originallyCreatedBean.getClass())) continue;
            Advice advice = (Advice)childBeanFactory.getBean(adviceName);
            DefaultPointcutAdvisor a = new DefaultPointcutAdvisor(pc, advice);
            if (pc instanceof Ordered) {
                a.setOrder(((Ordered)pc).getOrder());
                int insertionPos = 0;
                for (Advisor ad : pf.getAdvisors()) {
                    if (!(ad instanceof Ordered) || ((Ordered)ad).getOrder() >= a.getOrder()) break;
                    ++insertionPos;
                }
                pf.addAdvisor(insertionPos, (Advisor)a);
            } else {
                pf.addAdvisor((Advisor)a);
            }
            ++added;
        }
        return added > 0;
    }
}

