/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.HotSwappableTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.aop.targetsource.HotSwappable;
import org.springframework.config.java.process.ConfigurationListener;
import org.springframework.config.java.process.ConfigurationListenerSupport;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.core.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HotSwapConfigurationListener
extends ConfigurationListenerSupport {
    private List<Method> hotswapMethods = new LinkedList<Method>();

    HotSwapConfigurationListener() {
    }

    @Override
    public void beanCreationMethod(ConfigurationListener.BeanDefinitionRegistration beanDefinitionRegistration, ConfigurationProcessor cp, String configurerBeanName, Class<?> configurerClass, Method m, Bean beanAnnotation) {
        if (AnnotationUtils.findAnnotation((Method)m, HotSwappable.class) != null) {
            this.hotswapMethods.add(m);
        }
    }

    @Override
    public boolean processBeanMethodReturnValue(BeanFactory childBeanFactory, Object originallyCreatedBean, Method method, ProxyFactory pf) {
        if (this.hotswapMethods.contains(method)) {
            HotSwappableTargetSource hsts = new HotSwappableTargetSource(originallyCreatedBean);
            pf.setTargetSource((TargetSource)hsts);
            return true;
        }
        return false;
    }
}

