/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.kafka.annotation.KafkaHandler;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.annotation.KafkaListenerConfigurer;
import org.springframework.kafka.annotation.KafkaListeners;
import org.springframework.kafka.annotation.TopicPartition;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpointRegistrar;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.config.MultiMethodKafkaListenerEndpoint;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class KafkaListenerAnnotationBeanPostProcessor<K, V>
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    static final String DEFAULT_KAFKA_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "kafkaListenerContainerFactory";
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Log logger = LogFactory.getLog(this.getClass());
    private KafkaListenerEndpointRegistry endpointRegistry;
    private String containerFactoryBeanName = "kafkaListenerContainerFactory";
    private BeanFactory beanFactory;
    private final KafkaHandlerMethodFactoryAdapter messageHandlerMethodFactory = new KafkaHandlerMethodFactoryAdapter();
    private final KafkaListenerEndpointRegistrar registrar = new KafkaListenerEndpointRegistrar();
    private final AtomicInteger counter = new AtomicInteger();
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setEndpointRegistry(KafkaListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setContainerFactoryBeanName(String containerFactoryBeanName) {
        this.containerFactoryBeanName = containerFactoryBeanName;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(messageHandlerMethodFactory);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map instances = ((ListableBeanFactory)this.beanFactory).getBeansOfType(KafkaListenerConfigurer.class);
            for (KafkaListenerConfigurer configurer : instances.values()) {
                configurer.configureKafkaListeners(this.registrar);
            }
        }
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (KafkaListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.kafka.config.internalKafkaListenerEndpointRegistry", KafkaListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.containerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.containerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Collection<KafkaListener> classLevelListeners = this.findListenerAnnotations(targetClass);
            boolean hasClassLevelListeners = classLevelListeners.size() > 0;
            ArrayList<Method> multiMethods = new ArrayList<Method>();
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, (MethodIntrospector.MetadataLookup)new MethodIntrospector.MetadataLookup<Set<KafkaListener>>(){

                public Set<KafkaListener> inspect(Method method) {
                    Set listenerMethods = KafkaListenerAnnotationBeanPostProcessor.this.findListenerAnnotations(method);
                    return !listenerMethods.isEmpty() ? listenerMethods : null;
                }
            });
            if (hasClassLevelListeners) {
                Set methodsWithHandler = MethodIntrospector.selectMethods((Class)targetClass, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                    public boolean matches(Method method) {
                        return AnnotationUtils.findAnnotation((Method)method, KafkaHandler.class) != null;
                    }
                });
                multiMethods.addAll(methodsWithHandler);
            }
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("No @KafkaListener annotations found on bean type: " + bean.getClass()));
                }
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method = (Method)entry.getKey();
                    for (KafkaListener listener : (Set)entry.getValue()) {
                        this.processKafkaListener(listener, method, bean, beanName);
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(annotatedMethods.size() + " @KafkaListener methods processed on bean '" + beanName + "': " + annotatedMethods));
                }
            }
            if (hasClassLevelListeners) {
                this.processMultiMethodListeners(classLevelListeners, multiMethods, bean, beanName);
            }
        }
        return bean;
    }

    private Collection<KafkaListener> findListenerAnnotations(Class<?> clazz) {
        KafkaListeners anns;
        HashSet<KafkaListener> listeners = new HashSet<KafkaListener>();
        KafkaListener ann = (KafkaListener)AnnotationUtils.findAnnotation(clazz, KafkaListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (KafkaListeners)AnnotationUtils.findAnnotation(clazz, KafkaListeners.class)) != null) {
            listeners.addAll(Arrays.asList(anns.value()));
        }
        return listeners;
    }

    private Set<KafkaListener> findListenerAnnotations(Method method) {
        KafkaListeners anns;
        HashSet<KafkaListener> listeners = new HashSet<KafkaListener>();
        KafkaListener ann = (KafkaListener)AnnotationUtils.findAnnotation((Method)method, KafkaListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        if ((anns = (KafkaListeners)AnnotationUtils.findAnnotation((Method)method, KafkaListeners.class)) != null) {
            listeners.addAll(Arrays.asList(anns.value()));
        }
        return listeners;
    }

    private void processMultiMethodListeners(Collection<KafkaListener> classLevelListeners, List<Method> multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        for (Method method : multiMethods) {
            checkedMethods.add(this.checkProxy(method, bean));
        }
        for (KafkaListener classLevelListener : classLevelListeners) {
            MultiMethodKafkaListenerEndpoint endpoint = new MultiMethodKafkaListenerEndpoint(checkedMethods, bean);
            endpoint.setBeanFactory(this.beanFactory);
            this.processListener(endpoint, classLevelListener, bean, bean.getClass(), beanName);
        }
    }

    protected void processKafkaListener(KafkaListener kafkaListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodKafkaListenerEndpoint endpoint = new MethodKafkaListenerEndpoint();
        endpoint.setMethod(methodToUse);
        endpoint.setBeanFactory(this.beanFactory);
        this.processListener(endpoint, kafkaListener, bean, methodToUse, beanName);
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@KafkaListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    protected void processListener(MethodKafkaListenerEndpoint<?, ?> endpoint, KafkaListener kafkaListener, Object bean, Object adminTarget, String beanName) {
        Object resolvedGroup;
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory(this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(kafkaListener));
        endpoint.setTopicPartitions(this.resolveTopicPartitions(kafkaListener));
        endpoint.setTopics(this.resolveTopics(kafkaListener));
        endpoint.setTopicPattern(this.resolvePattern(kafkaListener));
        String group = kafkaListener.group();
        if (StringUtils.hasText((String)group) && (resolvedGroup = this.resolveExpression(group)) instanceof String) {
            endpoint.setGroup((String)resolvedGroup);
        }
        KafkaListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(kafkaListener.containerFactory());
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (KafkaListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, KafkaListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register Kafka listener endpoint on [" + adminTarget + "] for bean " + beanName + ", no " + KafkaListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanName + "' was found in the application context", (Throwable)ex);
            }
        }
        this.registrar.registerEndpoint(endpoint, factory);
    }

    private String getEndpointId(KafkaListener kafkaListener) {
        if (StringUtils.hasText((String)kafkaListener.id())) {
            return this.resolve(kafkaListener.id());
        }
        return "org.springframework.kafka.KafkaListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private org.apache.kafka.common.TopicPartition[] resolveTopicPartitions(KafkaListener kafkaListener) {
        TopicPartition[] topicPartitions = kafkaListener.topicPartitions();
        ArrayList<org.apache.kafka.common.TopicPartition> result = new ArrayList<org.apache.kafka.common.TopicPartition>();
        if (topicPartitions.length > 0) {
            for (TopicPartition topicPartition : topicPartitions) {
                result.addAll(this.resolveTopicPartitionsList(topicPartition));
            }
        }
        return result.toArray(new org.apache.kafka.common.TopicPartition[result.size()]);
    }

    private String[] resolveTopics(KafkaListener kafkaListener) {
        String[] topics = kafkaListener.topics();
        ArrayList<String> result = new ArrayList<String>();
        if (topics.length > 0) {
            for (int i = 0; i < topics.length; ++i) {
                Object topic = this.resolveExpression(topics[i]);
                this.resolveAsString(topic, result);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private Pattern resolvePattern(KafkaListener kafkaListener) {
        Pattern pattern = null;
        String text = kafkaListener.topicPattern();
        if (StringUtils.hasText((String)text)) {
            Object resolved = this.resolveExpression(text);
            if (resolved instanceof Pattern) {
                pattern = (Pattern)resolved;
            } else if (resolved instanceof String) {
                pattern = Pattern.compile((String)resolved);
            } else {
                throw new IllegalStateException("topicPattern must resolve to a Pattern or String, not " + resolved.getClass());
            }
        }
        return pattern;
    }

    private List<org.apache.kafka.common.TopicPartition> resolveTopicPartitionsList(TopicPartition topicPartition) {
        Object topic = this.resolveExpression(topicPartition.topic());
        Assert.state((boolean)(topic instanceof String), (String)("topic in @TopicPartition must resolve to a String, not " + topic.getClass()));
        Assert.state((boolean)StringUtils.hasText((String)((String)topic)), (String)"topic in @TopicPartition must not be empty");
        String[] partitions = topicPartition.partitions();
        Assert.state((partitions.length > 0 ? 1 : 0) != 0, (String)("At least one partition required in @TopicPartition for topic '" + topic + "'"));
        ArrayList<org.apache.kafka.common.TopicPartition> result = new ArrayList<org.apache.kafka.common.TopicPartition>();
        if (partitions.length > 0) {
            for (int i = 0; i < partitions.length; ++i) {
                this.resolvePartitionAsInteger((String)topic, partitions[i], result);
            }
        }
        return result;
    }

    private void resolveAsString(Object resolvedValue, List<String> result) {
        if (resolvedValue instanceof String[]) {
            for (String object : (String[])resolvedValue) {
                this.resolveAsString(object, result);
            }
        }
        if (resolvedValue instanceof String) {
            result.add((String)resolvedValue);
        } else if (resolvedValue instanceof Iterable) {
            for (Object object : (Iterable)resolvedValue) {
                this.resolveAsString(object, result);
            }
        } else {
            throw new IllegalArgumentException(String.format("@KafKaListener can't resolve '%s' as a String", resolvedValue));
        }
    }

    private void resolvePartitionAsInteger(String topic, Object resolvedValue, List<org.apache.kafka.common.TopicPartition> result) {
        if (resolvedValue instanceof String[]) {
            for (String object : (String[])resolvedValue) {
                this.resolvePartitionAsInteger(topic, object, result);
            }
        }
        if (resolvedValue instanceof String) {
            Assert.state((boolean)StringUtils.hasText((String)((String)resolvedValue)), (String)("partition in @TopicPartition for topic '" + topic + "' cannot be empty"));
            result.add(new org.apache.kafka.common.TopicPartition(topic, Integer.valueOf((String)resolvedValue).intValue()));
        } else if (resolvedValue instanceof Integer[]) {
            for (Integer partition : (Integer[])resolvedValue) {
                result.add(new org.apache.kafka.common.TopicPartition(topic, partition.intValue()));
            }
        } else if (resolvedValue instanceof Integer) {
            result.add(new org.apache.kafka.common.TopicPartition(topic, ((Integer)resolvedValue).intValue()));
        } else if (resolvedValue instanceof Iterable) {
            for (Object object : (Iterable)resolvedValue) {
                this.resolvePartitionAsInteger(topic, object, result);
            }
        } else {
            throw new IllegalArgumentException(String.format("@KafKaListener can't resolve '%s' as an Integer or String", resolvedValue));
        }
    }

    private Object resolveExpression(String value) {
        String resolvedValue = this.resolve(value);
        if (!resolvedValue.startsWith("#{") || !value.endsWith("}")) {
            return resolvedValue;
        }
        return this.resolver.evaluate(resolvedValue, this.expressionContext);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private class KafkaHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private KafkaHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory kafkaHandlerMethodFactory1) {
            this.messageHandlerMethodFactory = kafkaHandlerMethodFactory1;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            defaultFactory.setBeanFactory(KafkaListenerAnnotationBeanPostProcessor.this.beanFactory);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

