/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Collection;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.config.AbstractKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

public class SimpleKafkaListenerContainerFactory<K, V>
extends AbstractKafkaListenerContainerFactory<ConcurrentMessageListenerContainer<K, V>, K, V> {
    private Integer concurrency;
    private Long recentOffset;

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    public void setRecentOffset(Long recentOffset) {
        this.recentOffset = recentOffset;
    }

    @Override
    protected ConcurrentMessageListenerContainer<K, V> createContainerInstance(KafkaListenerEndpoint endpoint) {
        Collection<TopicPartition> topicPartitions = endpoint.getTopicPartitions();
        if (!topicPartitions.isEmpty()) {
            return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), topicPartitions.toArray(new TopicPartition[topicPartitions.size()]));
        }
        Collection<String> topics = endpoint.getTopics();
        if (!topics.isEmpty()) {
            return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), topics.toArray(new String[topics.size()]));
        }
        return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), endpoint.getTopicPattern());
    }

    @Override
    protected void initializeContainer(ConcurrentMessageListenerContainer<K, V> instance) {
        super.initializeContainer(instance);
        if (this.concurrency != null) {
            instance.setConcurrency(this.concurrency);
        }
        if (this.recentOffset != null) {
            instance.setRecentOffset(this.recentOffset);
        }
    }
}

