/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.util.Assert;

public abstract class AbstractMessageListenerContainer<K, V>
implements MessageListenerContainer,
BeanNameAware,
ApplicationEventPublisherAware,
SmartLifecycle {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ContainerProperties containerProperties;
    private final Object lifecycleMonitor = new Object();
    private String beanName;
    private ApplicationEventPublisher applicationEventPublisher;
    private boolean autoStartup = true;
    private int phase = 0;
    private volatile boolean running = false;

    protected AbstractMessageListenerContainer(ContainerProperties containerProperties) {
        Assert.notNull((Object)containerProperties, (String)"'containerProperties' cannot be null");
        this.containerProperties = containerProperties;
        if (containerProperties.getConsumerRebalanceListener() == null) {
            containerProperties.setConsumerRebalanceListener(this.createConsumerRebalanceListener());
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.containerProperties.setMessageListener(messageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            Assert.isTrue((this.containerProperties.getMessageListener() instanceof MessageListener || this.containerProperties.getMessageListener() instanceof AcknowledgingMessageListener ? 1 : 0) != 0, (String)("Either a " + MessageListener.class.getName() + " or a " + AcknowledgingMessageListener.class.getName() + " must be provided"));
            this.doStart();
        }
    }

    protected abstract void doStart();

    public final void stop() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.stop(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        try {
            latch.await(this.containerProperties.getShutdownTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.doStop(callback);
        }
    }

    protected abstract void doStop(Runnable var1);

    protected final ConsumerRebalanceListener createConsumerRebalanceListener() {
        return new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info((Object)("partitions revoked:" + partitions));
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                AbstractMessageListenerContainer.this.logger.info((Object)("partitions assigned:" + partitions));
            }
        };
    }

    public static enum AckMode {
        RECORD,
        BATCH,
        TIME,
        COUNT,
        COUNT_TIME,
        MANUAL,
        MANUAL_IMMEDIATE,
        MANUAL_IMMEDIATE_SYNC;

    }
}

