/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.MessagingMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class StringJsonMessageConverter
extends MessagingMessageConverter {
    private final ObjectMapper objectMapper;

    public StringJsonMessageConverter() {
        this(new ObjectMapper());
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public StringJsonMessageConverter(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null.");
        this.objectMapper = objectMapper;
    }

    @Override
    protected Object convertPayload(Message<?> message) {
        try {
            return this.objectMapper.writeValueAsString(message.getPayload());
        }
        catch (JsonProcessingException e) {
            throw new ConversionException("Failed to convert to JSON", e);
        }
    }

    @Override
    protected Object extractAndConvertValue(ConsumerRecord<?, ?> record, Type type) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        Object value = record.value();
        if (value instanceof String) {
            try {
                return this.objectMapper.readValue((String)value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", e);
            }
        }
        if (value instanceof byte[]) {
            try {
                return this.objectMapper.readValue((byte[])value, javaType);
            }
            catch (IOException e) {
                throw new ConversionException("Failed to convert from JSON", e);
            }
        }
        throw new IllegalStateException("Only String or byte[] supported");
    }
}

