/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.adapter.AbstractRetryingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RetryingAcknowledgingMessageListenerAdapter<K, V>
extends AbstractRetryingMessageListenerAdapter<K, V, AcknowledgingMessageListener<K, V>>
implements AcknowledgingMessageListener<K, V> {
    private final AcknowledgingMessageListener<K, V> delegate;

    public RetryingAcknowledgingMessageListenerAdapter(AcknowledgingMessageListener<K, V> messageListener, RetryTemplate retryTemplate) {
        this(messageListener, retryTemplate, (RecoveryCallback<Object>)null);
    }

    public RetryingAcknowledgingMessageListenerAdapter(AcknowledgingMessageListener<K, V> messageListener, RetryTemplate retryTemplate, RecoveryCallback<? extends Object> recoveryCallback) {
        super(messageListener, retryTemplate, recoveryCallback);
        Assert.notNull(messageListener, (String)"'messageListener' cannot be null");
        this.delegate = messageListener;
    }

    @Override
    public void onMessage(final ConsumerRecord<K, V> record, final Acknowledgment acknowledgment) {
        this.getRetryTemplate().execute((RetryCallback)new RetryCallback<Object, KafkaException>(){

            public Void doWithRetry(RetryContext context) throws KafkaException {
                context.setAttribute("record", (Object)record);
                RetryingAcknowledgingMessageListenerAdapter.this.delegate.onMessage(record, acknowledgment);
                return null;
            }
        }, this.getRecoveryCallback());
    }
}

