/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.listener.AfterRollbackProcessor;

public class DefaultAfterRollbackProcessor<K, V>
implements AfterRollbackProcessor<K, V> {
    private static final Log logger = LogFactory.getLog(DefaultAfterRollbackProcessor.class);

    @Override
    public void process(List<ConsumerRecord<K, V>> records, Consumer<K, V> consumer) {
        HashSet<TopicPartition> seekOffsets = new HashSet<TopicPartition>();
        for (ConsumerRecord<K, V> record : records) {
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            if (!seekOffsets.add(topicPartition)) continue;
            try {
                consumer.seek(topicPartition, record.offset());
            }
            catch (Exception e) {
                logger.error((Object)("Failed to seek " + topicPartition + " to " + record.offset()));
            }
        }
    }
}

