/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SerializationException;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.listener.LoggingCommitCallback;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.lang.Nullable;

public class SeekToCurrentErrorHandler
implements ContainerAwareErrorHandler {
    protected static final Log LOGGER = LogFactory.getLog(SeekToCurrentErrorHandler.class);
    private static final LoggingCommitCallback LOGGING_COMMIT_CALLBACK = new LoggingCommitCallback();
    private final FailedRecordTracker failureTracker;
    private boolean commitRecovered;

    public SeekToCurrentErrorHandler() {
        this(null, 10);
    }

    public SeekToCurrentErrorHandler(int maxFailures) {
        this(null, maxFailures);
    }

    public SeekToCurrentErrorHandler(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, 10);
    }

    public SeekToCurrentErrorHandler(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        this.failureTracker = new FailedRecordTracker(recoverer, maxFailures, LOGGER);
    }

    protected boolean isCommitRecovered() {
        return this.commitRecovered;
    }

    public void setCommitRecovered(boolean commitRecovered) {
        this.commitRecovered = commitRecovered;
    }

    @Override
    public void handle(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        if (thrownException instanceof SerializationException) {
            throw new IllegalStateException("This error handler cannot process 'SerializationException's directly, please consider configuring an 'ErrorHandlingDeserializer2' in the value and/or key deserializer", thrownException);
        }
        if (!SeekUtils.doSeeks(records, consumer, thrownException, true, this.failureTracker::skip, LOGGER)) {
            throw new KafkaException("Seek to current after exception", thrownException);
        }
        if (this.commitRecovered) {
            if (container.getContainerProperties().getAckMode().equals((Object)ContainerProperties.AckMode.MANUAL_IMMEDIATE)) {
                ConsumerRecord<?, ?> record = records.get(0);
                Map<TopicPartition, OffsetAndMetadata> offsetToCommit = Collections.singletonMap(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
                if (container.getContainerProperties().isSyncCommits()) {
                    consumer.commitSync(offsetToCommit);
                } else {
                    OffsetCommitCallback commitCallback = container.getContainerProperties().getCommitCallback();
                    if (commitCallback == null) {
                        commitCallback = LOGGING_COMMIT_CALLBACK;
                    }
                    consumer.commitAsync(offsetToCommit, commitCallback);
                }
            } else {
                LOGGER.warn((Object)"'commitRecovered' ignored, container AckMode must be MANUAL_IMMEDIATE");
            }
        }
    }

    @Override
    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }
}

